/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.conversion;

import java.text.*;
import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.control.*;

/**
 * BStatusNumericToStatusString is a component that converts a StatusNumeric to a StatusString.
 *
 * @author    Andy Saunders
 * @creation  05 April 2004
 * @version   $Revision: 7$ $Date: 3/3/2004 8:48:19 AM$
 * @since     Baja 1.0
 */
public class BStatusNumericToStatusString
  extends BComponent
  implements BIStatus
{
  /*-
  
  class BStatusNumericToStatusString
  {
    properties
    {
      
      out: BStatusString
        flags { transient, readonly, summary }
        default {[ new BStatusString() ]}

      in: BStatusNumeric
        flags { transient, summary }
        default {[ new BStatusNumeric() ]}

      integerDigits: int
        default {[ 6 ]}

      decimalDigits: int
        default {[ 6 ]}

    }

    actions
    {
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.conversion.BStatusNumericToStatusString(2646486606)1.0$ @*/
/* Generated Wed Apr 27 09:46:55 EDT 2005 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToStatusString#getOut
   * @see com.tridium.kitControl.conversion.BStatusNumericToStatusString#setOut
   */
  public static final Property out = newProperty(Flags.TRANSIENT|Flags.READONLY|Flags.SUMMARY, new BStatusString(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToStatusString#out
   */
  public BStatusString getOut() { return (BStatusString)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToStatusString#out
   */
  public void setOut(BStatusString v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Property "in"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToStatusString#getIn
   * @see com.tridium.kitControl.conversion.BStatusNumericToStatusString#setIn
   */
  public static final Property in = newProperty(Flags.TRANSIENT|Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToStatusString#in
   */
  public BStatusNumeric getIn() { return (BStatusNumeric)get(in); }
  
  /**
   * Set the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToStatusString#in
   */
  public void setIn(BStatusNumeric v) { set(in,v,null); }

////////////////////////////////////////////////////////////////
// Property "integerDigits"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>integerDigits</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToStatusString#getIntegerDigits
   * @see com.tridium.kitControl.conversion.BStatusNumericToStatusString#setIntegerDigits
   */
  public static final Property integerDigits = newProperty(0, 6,null);
  
  /**
   * Get the <code>integerDigits</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToStatusString#integerDigits
   */
  public int getIntegerDigits() { return getInt(integerDigits); }
  
  /**
   * Set the <code>integerDigits</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToStatusString#integerDigits
   */
  public void setIntegerDigits(int v) { setInt(integerDigits,v,null); }

////////////////////////////////////////////////////////////////
// Property "decimalDigits"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>decimalDigits</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToStatusString#getDecimalDigits
   * @see com.tridium.kitControl.conversion.BStatusNumericToStatusString#setDecimalDigits
   */
  public static final Property decimalDigits = newProperty(0, 6,null);
  
  /**
   * Get the <code>decimalDigits</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToStatusString#decimalDigits
   */
  public int getDecimalDigits() { return getInt(decimalDigits); }
  
  /**
   * Set the <code>decimalDigits</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToStatusString#decimalDigits
   */
  public void setDecimalDigits(int v) { setInt(decimalDigits,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStatusNumericToStatusString.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BStatusNumericToStatusString()
  {
  }
  
  /**
   * Init if started after steady state has been reached.
   */
  public void started()
  {
    calculate();
  }

/**
   * setoutput on in change.
   */
  public void changed(Property p, Context cx)
  {
    if (!isRunning()) return;

    if (p == in || p == decimalDigits || p == integerDigits)
    {
      calculate();
    }
  }

  void calculate()
  {
    double inValue = getIn().getValue();
    workingValue.setStatus(getIn().getStatus());
    int precision = getDecimalDigits();
    int integer   = getIntegerDigits();
    NumberFormat format = NumberFormat.getNumberInstance();
    format.setMaximumFractionDigits(precision);
    format.setMinimumFractionDigits(precision);
    format.setMaximumIntegerDigits(integer);
    format.setMinimumIntegerDigits(integer);
    format.setGroupingUsed(false);
    String value = format.format(inValue);
    try
    {
      workingValue.setValue(value);
    }
    catch(Exception e)
    {
      workingValue.setStatusNull(true);
      workingValue.setStatusFault(true);
    }
    setOut(workingValue);
  }

  public String toString(Context cx)
  {
    return getOut().toString(cx);
  }


////////////////////////////////////////////////////////////////
// BIStatus interface
////////////////////////////////////////////////////////////////

  public BStatus getStatus() { return getOut().getStatus(); }
  

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/control.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  BStatusString workingValue = new BStatusString();
  
}
