/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.conversion;

import java.text.*;
import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.control.*;

/**
 * BStatusNumericToStatusEnum is a component that converts a StatusNumeric to a StatusEnum.
 *
 * @author    Andy Saunders
 * @creation  15 March 2006
 * @version   $Revision: 7$ $Date: 3/3/2004 8:48:19 AM$
 * @since     Baja 1.0
 */
public class BStatusNumericToStatusEnum
  extends BComponent
  implements BIStatus
{
  /*-
  
  class BStatusNumericToStatusEnum
  {
    properties
    {
      
      facets: BFacets
        -- These facets are applied against the out property.
        default {[ BFacets.makeEnum() ]}

      out: BStatusEnum
        flags { transient, readonly, summary }
        default {[ new BStatusEnum() ]}

      in: BStatusNumeric
        flags { transient, summary }
        default {[ new BStatusNumeric() ]}

    }

    actions
    {
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.conversion.BStatusNumericToStatusEnum(1197545111)1.0$ @*/
/* Generated Wed Mar 15 09:04:05 EST 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "facets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>facets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToStatusEnum#getFacets
   * @see com.tridium.kitControl.conversion.BStatusNumericToStatusEnum#setFacets
   */
  public static final Property facets = newProperty(0, BFacets.makeEnum(),null);
  
  /**
   * Get the <code>facets</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToStatusEnum#facets
   */
  public BFacets getFacets() { return (BFacets)get(facets); }
  
  /**
   * Set the <code>facets</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToStatusEnum#facets
   */
  public void setFacets(BFacets v) { set(facets,v,null); }

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToStatusEnum#getOut
   * @see com.tridium.kitControl.conversion.BStatusNumericToStatusEnum#setOut
   */
  public static final Property out = newProperty(Flags.TRANSIENT|Flags.READONLY|Flags.SUMMARY, new BStatusEnum(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToStatusEnum#out
   */
  public BStatusEnum getOut() { return (BStatusEnum)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToStatusEnum#out
   */
  public void setOut(BStatusEnum v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Property "in"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToStatusEnum#getIn
   * @see com.tridium.kitControl.conversion.BStatusNumericToStatusEnum#setIn
   */
  public static final Property in = newProperty(Flags.TRANSIENT|Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToStatusEnum#in
   */
  public BStatusNumeric getIn() { return (BStatusNumeric)get(in); }
  
  /**
   * Set the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToStatusEnum#in
   */
  public void setIn(BStatusNumeric v) { set(in,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStatusNumericToStatusEnum.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BStatusNumericToStatusEnum()
  {
  }
  
  /**
   * Init if started after steady state has been reached.
   */
  public void started()
  {
    calculate();
  }

/**
   * setoutput on in change.
   */
  public void changed(Property p, Context cx)
  {
    if (!isRunning()) return;

    if (p.equals(in) )
    {
      calculate();
    }
  }

  void calculate()
  {
    BStatusEnum workingValue = getOut();
    double inValue = getIn().getValue();
    if(inValue <= (double)Integer.MAX_VALUE &&
       inValue >= (double)Integer.MIN_VALUE    )
    {
      workingValue.setValue(BDynamicEnum.make((int)getIn().getValue()) );
      workingValue.setStatusNull(false);
      workingValue.setStatusFault(false);
    }
    else    
    {
      workingValue.setStatusNull(true);
      workingValue.setStatusFault(true);
    }
    setOut(workingValue);
  }

  public String toString(Context cx)
  {
    return getOut().toString(cx);
  }

  /**
   * Apply the "facets" property to the "out" property.
   */
  public BFacets getSlotFacets(Slot slot)
  {
    if (slot == out) return getFacets();
    return super.getSlotFacets(slot);
  }


////////////////////////////////////////////////////////////////
// BIStatus interface
////////////////////////////////////////////////////////////////

  public BStatus getStatus() { return getOut().getStatus(); }
  

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/control.png");

  
}
