/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.conversion;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.control.*;
import javax.baja.units.*;

import com.tridium.kitControl.enums.BNullValueOverrideSelect;

/**
 * BStatusNumericToInt is a component that converts a statusNumeric to a int.
 *
 * @author    Andy Saunders
 * @creation  05 April 2004
 * @version   $Revision: 7$ $Date: 3/3/2004 8:48:19 AM$
 * @since     Baja 1.0
 */
public class BStatusNumericToInt
  extends BStatusValueToValue
{
  /*-
  
  class BStatusNumericToInt
  {
    properties
    {
      
      facets: BFacets
        -- These facets are applied against the out property.
        default {[ BFacets.make(BFacets.UNITS, BUnit.NULL, BFacets.RADIX, BInteger.make(10) ) ]}
        
      out: int
        flags { transient, readonly, summary }
        default {[ 0 ]}

      in: BStatusNumeric
        flags { transient, summary }
        default {[ new BStatusNumeric() ]}

      onNullInValue: BNullValueOverrideSelect
        default {[ BNullValueOverrideSelect.useInValue ]}

    }

    actions
    {
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.conversion.BStatusNumericToInt(776487442)1.0$ @*/
/* Generated Fri Jul 16 06:59:43 EDT 2010 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "facets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>facets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToInt#getFacets
   * @see com.tridium.kitControl.conversion.BStatusNumericToInt#setFacets
   */
  public static final Property facets = newProperty(0, BFacets.make(BFacets.UNITS, BUnit.NULL, BFacets.RADIX, BInteger.make(10) ),null);
  
  /**
   * Get the <code>facets</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToInt#facets
   */
  public BFacets getFacets() { return (BFacets)get(facets); }
  
  /**
   * Set the <code>facets</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToInt#facets
   */
  public void setFacets(BFacets v) { set(facets,v,null); }

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToInt#getOut
   * @see com.tridium.kitControl.conversion.BStatusNumericToInt#setOut
   */
  public static final Property out = newProperty(Flags.TRANSIENT|Flags.READONLY|Flags.SUMMARY, 0,null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToInt#out
   */
  public int getOut() { return getInt(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToInt#out
   */
  public void setOut(int v) { setInt(out,v,null); }

////////////////////////////////////////////////////////////////
// Property "in"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToInt#getIn
   * @see com.tridium.kitControl.conversion.BStatusNumericToInt#setIn
   */
  public static final Property in = newProperty(Flags.TRANSIENT|Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToInt#in
   */
  public BStatusNumeric getIn() { return (BStatusNumeric)get(in); }
  
  /**
   * Set the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToInt#in
   */
  public void setIn(BStatusNumeric v) { set(in,v,null); }

////////////////////////////////////////////////////////////////
// Property "onNullInValue"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>onNullInValue</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToInt#getOnNullInValue
   * @see com.tridium.kitControl.conversion.BStatusNumericToInt#setOnNullInValue
   */
  public static final Property onNullInValue = newProperty(0, BNullValueOverrideSelect.useInValue,null);
  
  /**
   * Get the <code>onNullInValue</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToInt#onNullInValue
   */
  public BNullValueOverrideSelect getOnNullInValue() { return (BNullValueOverrideSelect)get(onNullInValue); }
  
  /**
   * Set the <code>onNullInValue</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToInt#onNullInValue
   */
  public void setOnNullInValue(BNullValueOverrideSelect v) { set(onNullInValue,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStatusNumericToInt.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BStatusNumericToInt()
  {
  }
  
  /**
   * Init if started after steady state has been reached.
   */
  public void started()
  {
    execute();
  }

  /**
   * set output on in change.
   */
  public void changed(Property p, Context cx)
  {
    if (!isRunning()) return;

    if( p.equals(in) )
    {
      execute();
    }
    else super.changed(p, cx);
  }

  public void execute()
  {
    setOut( ((BNumber)calculate(getIn())).getInt());
  }

  public Type getOutType()
  {
    return BInteger.TYPE;
  }
  
  public String toString(Context cx)
  {
    return BInteger.make(getOut()).toString(cx);
  }

  /**
   * Apply the "facets" property to the "out" property.
   */
  public BFacets getSlotFacets(Slot slot)
  {
    if (slot == out) return getFacets();
    return super.getSlotFacets(slot);
  }

  public BFacets getOutFacets()
  {
    return getFacets();
  }

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/control.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  
}
