/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.conversion;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.control.*;
import javax.baja.units.*;

import com.tridium.kitControl.enums.BNullValueOverrideSelect;

/**
 * BStatusNumericToDouble is a component that converts a float to a statusNumeric.
 *
 * @author    Andy Saunders
 * @creation  05 April 2004
 * @version   $Revision: 7$ $Date: 3/3/2004 8:48:19 AM$
 * @since     Baja 1.0
 */
public class BStatusNumericToDouble
  extends BStatusValueToValue
{

  /*-
  
  class BStatusNumericToDouble
  {
    properties
    {
      
      facets: BFacets
        -- These facets are applied against the out property.
        default {[ BFacets.make(BFacets.UNITS, BUnit.NULL, BFacets.PRECISION, BInteger.make(1) ) ]}
        
      out: double
        flags { transient, readonly, summary }
        default {[ 0.0d ]}

      in: BStatusNumeric
        flags { transient, summary }
        default {[ new BStatusNumeric() ]}
        
      onNullInValue: BNullValueOverrideSelect
        default {[ BNullValueOverrideSelect.useInValue ]}
    }

    actions
    {
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.conversion.BStatusNumericToDouble(1060823648)1.0$ @*/
/* Generated Fri Jul 16 06:25:26 EDT 2010 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "facets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>facets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToDouble#getFacets
   * @see com.tridium.kitControl.conversion.BStatusNumericToDouble#setFacets
   */
  public static final Property facets = newProperty(0, BFacets.make(BFacets.UNITS, BUnit.NULL, BFacets.PRECISION, BInteger.make(1) ),null);
  
  /**
   * Get the <code>facets</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToDouble#facets
   */
  public BFacets getFacets() { return (BFacets)get(facets); }
  
  /**
   * Set the <code>facets</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToDouble#facets
   */
  public void setFacets(BFacets v) { set(facets,v,null); }

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToDouble#getOut
   * @see com.tridium.kitControl.conversion.BStatusNumericToDouble#setOut
   */
  public static final Property out = newProperty(Flags.TRANSIENT|Flags.READONLY|Flags.SUMMARY, 0.0d,null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToDouble#out
   */
  public double getOut() { return getDouble(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToDouble#out
   */
  public void setOut(double v) { setDouble(out,v,null); }

////////////////////////////////////////////////////////////////
// Property "in"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToDouble#getIn
   * @see com.tridium.kitControl.conversion.BStatusNumericToDouble#setIn
   */
  public static final Property in = newProperty(Flags.TRANSIENT|Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToDouble#in
   */
  public BStatusNumeric getIn() { return (BStatusNumeric)get(in); }
  
  /**
   * Set the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToDouble#in
   */
  public void setIn(BStatusNumeric v) { set(in,v,null); }

////////////////////////////////////////////////////////////////
// Property "onNullInValue"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>onNullInValue</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToDouble#getOnNullInValue
   * @see com.tridium.kitControl.conversion.BStatusNumericToDouble#setOnNullInValue
   */
  public static final Property onNullInValue = newProperty(0, BNullValueOverrideSelect.useInValue,null);
  
  /**
   * Get the <code>onNullInValue</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToDouble#onNullInValue
   */
  public BNullValueOverrideSelect getOnNullInValue() { return (BNullValueOverrideSelect)get(onNullInValue); }
  
  /**
   * Set the <code>onNullInValue</code> property.
   * @see com.tridium.kitControl.conversion.BStatusNumericToDouble#onNullInValue
   */
  public void setOnNullInValue(BNullValueOverrideSelect v) { set(onNullInValue,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStatusNumericToDouble.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BStatusNumericToDouble()
  {
  }
  
  /**
   * Init if started after steady state has been reached.
   */
  public void started()
  {
    execute();
  }

/**
   * setoutput on in change.
   */
  public void changed(Property p, Context cx)
  {
    if (!isRunning()) return;

    if( p.equals(in) )
    {
      execute();
    }
    else super.changed(p, cx);
  }

  public void execute()
  {
    setOut( ((BDouble)calculate(getIn())).getDouble());
  }

  public Type getOutType()
  {
    return BDouble.TYPE;
  }
  

  public String toString(Context cx)
  {
    return BDouble.make(getOut()).toString(cx);
  }

  /**
   * Apply the "facets" property to the "out" property.
   */
  public BFacets getSlotFacets(Slot slot)
  {
    if (slot == out) return getFacets();
    return super.getSlotFacets(slot);
  }

  public BFacets getOutFacets()
  {
    return getFacets();
  }

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/control.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
}
