/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.conversion;

import java.text.*;
import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.control.*;
import javax.baja.units.*;
import com.tridium.bql.filter.*;
import com.tridium.kitControl.enums.BNullValueOverrideSelect;
/**
 * BStatusEnumToInt is a component that converts a StatusEnum to a Integer.
 *
 * @author    Andy Saunders
 * @creation  18 May 2005
 * @version   $Revision: 7$ $Date: 3/3/2004 8:48:19 AM$
 * @since     Baja 1.0
 */
public class BStatusEnumToInt
  extends BStatusValueToValue
{
  /*-
  
  class BStatusEnumToInt
  {
    properties
    {
      
      outFacets: BFacets
        -- These facets are applied against the out property.
        default {[ BFacets.makeInt() ]}
        
      inFacets: BFacets
        -- These facets are applied against the in property.
        default {[ BFacets.makeEnum() ]}
        
      out: int
        flags { transient, readonly, summary }
        default {[ 0 ]}

      in: BStatusEnum
        flags { transient, summary }
        default {[ new BStatusEnum() ]}
        
      onNullInValue: BNullValueOverrideSelect
        default {[ BNullValueOverrideSelect.useInValue ]}
    }

    actions
    {
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.conversion.BStatusEnumToInt(4033234957)1.0$ @*/
/* Generated Fri Jul 16 07:12:32 EDT 2010 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "outFacets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outFacets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToInt#getOutFacets
   * @see com.tridium.kitControl.conversion.BStatusEnumToInt#setOutFacets
   */
  public static final Property outFacets = newProperty(0, BFacets.makeInt(),null);
  
  /**
   * Get the <code>outFacets</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToInt#outFacets
   */
  public BFacets getOutFacets() { return (BFacets)get(outFacets); }
  
  /**
   * Set the <code>outFacets</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToInt#outFacets
   */
  public void setOutFacets(BFacets v) { set(outFacets,v,null); }

////////////////////////////////////////////////////////////////
// Property "inFacets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inFacets</code> property.
   * These facets are applied against the in property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToInt#getInFacets
   * @see com.tridium.kitControl.conversion.BStatusEnumToInt#setInFacets
   */
  public static final Property inFacets = newProperty(0, BFacets.makeEnum(),null);
  
  /**
   * Get the <code>inFacets</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToInt#inFacets
   */
  public BFacets getInFacets() { return (BFacets)get(inFacets); }
  
  /**
   * Set the <code>inFacets</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToInt#inFacets
   */
  public void setInFacets(BFacets v) { set(inFacets,v,null); }

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToInt#getOut
   * @see com.tridium.kitControl.conversion.BStatusEnumToInt#setOut
   */
  public static final Property out = newProperty(Flags.TRANSIENT|Flags.READONLY|Flags.SUMMARY, 0,null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToInt#out
   */
  public int getOut() { return getInt(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToInt#out
   */
  public void setOut(int v) { setInt(out,v,null); }

////////////////////////////////////////////////////////////////
// Property "in"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToInt#getIn
   * @see com.tridium.kitControl.conversion.BStatusEnumToInt#setIn
   */
  public static final Property in = newProperty(Flags.TRANSIENT|Flags.SUMMARY, new BStatusEnum(),null);
  
  /**
   * Get the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToInt#in
   */
  public BStatusEnum getIn() { return (BStatusEnum)get(in); }
  
  /**
   * Set the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToInt#in
   */
  public void setIn(BStatusEnum v) { set(in,v,null); }

////////////////////////////////////////////////////////////////
// Property "onNullInValue"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>onNullInValue</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToInt#getOnNullInValue
   * @see com.tridium.kitControl.conversion.BStatusEnumToInt#setOnNullInValue
   */
  public static final Property onNullInValue = newProperty(0, BNullValueOverrideSelect.useInValue,null);
  
  /**
   * Get the <code>onNullInValue</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToInt#onNullInValue
   */
  public BNullValueOverrideSelect getOnNullInValue() { return (BNullValueOverrideSelect)get(onNullInValue); }
  
  /**
   * Set the <code>onNullInValue</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToInt#onNullInValue
   */
  public void setOnNullInValue(BNullValueOverrideSelect v) { set(onNullInValue,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStatusEnumToInt.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BStatusEnumToInt()
  {
  }
  
  /**
   * Init if started after steady state has been reached.
   */
  public void started()
  {
    execute();
  }

  /**
   * setoutput on in change.
   */
  public void changed(Property p, Context cx)
  {
    if (!isRunning()) return;

    if (p == in)
    {
      execute();
    }
    else super.changed(p, cx);
  }

  public void execute()
  {
    BValue calcValue = calculate(getIn());
    if(calcValue.getType().is(BDynamicEnum.TYPE))
      setOut( ((BDynamicEnum)calcValue).getOrdinal() );
    else
      setOut( ((BInteger)calcValue).getInt() );
  }

  public Type getOutType()
  {
    return BInteger.TYPE;
  }
  
  /**
   * Apply the "facets" property to the "out" property.
   */
  public BFacets getSlotFacets(Slot slot)
  {
    if (slot == out) return getOutFacets();
    if (slot == in) return getInFacets();
    return super.getSlotFacets(slot);
  }


//  void calculate()
//  {
//    //BEnum enumValue =  getIn().getValue();
//    setOut( getIn().getValue().getOrdinal() );
//  }

  public String toString(Context cx)
  {
    StringBuffer s = new StringBuffer();
    s.append(getOut());
    return s.toString();
  }
  
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/control.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
}
