/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.conversion;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.control.*;

import com.tridium.kitControl.enums.BNullValueOverrideSelect;

/**
 * BStatusEnumToEnum is a component that converts a statusEnum to a DynamicEnum.
 *
 * @author    Andy Saunders
 * @creation  05 April 2004
 * @version   $Revision: 7$ $Date: 3/3/2004 8:48:19 AM$
 * @since     Baja 1.0
 */
public class BStatusEnumToEnum
  extends BStatusValueToValue

{

  /*-
  
  class BStatusEnumToEnum
  {
    properties
    {
      
      facets: BFacets
        -- These facets are applied against the out property.
        default {[ BFacets.makeEnum() ]}
        
      in: BStatusEnum
        flags { transient, summary }
        default {[ new BStatusEnum() ]}

      out: BDynamicEnum
        flags { transient, readonly, summary }
        default {[ BDynamicEnum.make(0) ]}

      onNullInValue: BNullValueOverrideSelect
        default {[ BNullValueOverrideSelect.useInValue ]}
    }

    actions
    {
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.conversion.BStatusEnumToEnum(3811977965)1.0$ @*/
/* Generated Fri Jul 16 06:25:26 EDT 2010 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "facets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>facets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToEnum#getFacets
   * @see com.tridium.kitControl.conversion.BStatusEnumToEnum#setFacets
   */
  public static final Property facets = newProperty(0, BFacets.makeEnum(),null);
  
  /**
   * Get the <code>facets</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToEnum#facets
   */
  public BFacets getFacets() { return (BFacets)get(facets); }
  
  /**
   * Set the <code>facets</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToEnum#facets
   */
  public void setFacets(BFacets v) { set(facets,v,null); }

////////////////////////////////////////////////////////////////
// Property "in"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToEnum#getIn
   * @see com.tridium.kitControl.conversion.BStatusEnumToEnum#setIn
   */
  public static final Property in = newProperty(Flags.TRANSIENT|Flags.SUMMARY, new BStatusEnum(),null);
  
  /**
   * Get the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToEnum#in
   */
  public BStatusEnum getIn() { return (BStatusEnum)get(in); }
  
  /**
   * Set the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToEnum#in
   */
  public void setIn(BStatusEnum v) { set(in,v,null); }

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToEnum#getOut
   * @see com.tridium.kitControl.conversion.BStatusEnumToEnum#setOut
   */
  public static final Property out = newProperty(Flags.TRANSIENT|Flags.READONLY|Flags.SUMMARY, BDynamicEnum.make(0),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToEnum#out
   */
  public BDynamicEnum getOut() { return (BDynamicEnum)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToEnum#out
   */
  public void setOut(BDynamicEnum v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Property "onNullInValue"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>onNullInValue</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToEnum#getOnNullInValue
   * @see com.tridium.kitControl.conversion.BStatusEnumToEnum#setOnNullInValue
   */
  public static final Property onNullInValue = newProperty(0, BNullValueOverrideSelect.useInValue,null);
  
  /**
   * Get the <code>onNullInValue</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToEnum#onNullInValue
   */
  public BNullValueOverrideSelect getOnNullInValue() { return (BNullValueOverrideSelect)get(onNullInValue); }
  
  /**
   * Set the <code>onNullInValue</code> property.
   * @see com.tridium.kitControl.conversion.BStatusEnumToEnum#onNullInValue
   */
  public void setOnNullInValue(BNullValueOverrideSelect v) { set(onNullInValue,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStatusEnumToEnum.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BStatusEnumToEnum()
  {
  }
  
  /**
   * Init if started after steady state has been reached.
   */
  public void started()
  {
    execute();
  }

/**
   * setoutput on in change.
   */
  public void changed(Property p, Context cx)
  {
    if (!isRunning()) return;

    if (p == in)
    {
      execute();
    }
    else super.changed(p, cx);
  }

  public void execute()
  {
    setOut( (BDynamicEnum)calculate(getIn()) );
  }

  public Type getOutType()
  {
    return BDynamicEnum.TYPE;
  }
  


  public String toString(Context cx)
  {
    return getOut().toString(cx);
  }

  /**
   * Apply the "facets" property to the "out" property.
   */
  public BFacets getSlotFacets(Slot slot)
  {
    if (slot == out) return getFacets();
    return super.getSlotFacets(slot);
  }

  public BFacets getOutFacets()
  {
    return getFacets();
  }

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/control.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  
}
