/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.conversion;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.control.*;

import com.tridium.kitControl.enums.BNullValueOverrideSelect;

/**
 * BStatusBooleanToBoolean is a component that converts a statusNumeric to a int.
 *
 * @author    Andy Saunders
 * @creation  05 April 2004
 * @version   $Revision: 7$ $Date: 3/3/2004 8:48:19 AM$
 * @since     Baja 1.0
 */
public class BStatusBooleanToBoolean
  extends BStatusValueToValue
{
  /*-
  
  class BStatusBooleanToBoolean
  {
    properties
    {
      
      facets: BFacets
        -- These facets are applied against the out property.
        default {[ BFacets.makeBoolean() ]}
        
      in: BStatusBoolean
        flags { transient, summary }
        default {[ new BStatusBoolean() ]}

      out: boolean
        flags { transient, readonly, summary }
        default {[ false ]}

      onNullInValue: BNullValueOverrideSelect
        default {[ BNullValueOverrideSelect.useInValue ]}

    }

    actions
    {
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.conversion.BStatusBooleanToBoolean(3037295949)1.0$ @*/
/* Generated Fri Jul 16 07:12:32 EDT 2010 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "facets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>facets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.conversion.BStatusBooleanToBoolean#getFacets
   * @see com.tridium.kitControl.conversion.BStatusBooleanToBoolean#setFacets
   */
  public static final Property facets = newProperty(0, BFacets.makeBoolean(),null);
  
  /**
   * Get the <code>facets</code> property.
   * @see com.tridium.kitControl.conversion.BStatusBooleanToBoolean#facets
   */
  public BFacets getFacets() { return (BFacets)get(facets); }
  
  /**
   * Set the <code>facets</code> property.
   * @see com.tridium.kitControl.conversion.BStatusBooleanToBoolean#facets
   */
  public void setFacets(BFacets v) { set(facets,v,null); }

////////////////////////////////////////////////////////////////
// Property "in"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BStatusBooleanToBoolean#getIn
   * @see com.tridium.kitControl.conversion.BStatusBooleanToBoolean#setIn
   */
  public static final Property in = newProperty(Flags.TRANSIENT|Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BStatusBooleanToBoolean#in
   */
  public BStatusBoolean getIn() { return (BStatusBoolean)get(in); }
  
  /**
   * Set the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BStatusBooleanToBoolean#in
   */
  public void setIn(BStatusBoolean v) { set(in,v,null); }

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BStatusBooleanToBoolean#getOut
   * @see com.tridium.kitControl.conversion.BStatusBooleanToBoolean#setOut
   */
  public static final Property out = newProperty(Flags.TRANSIENT|Flags.READONLY|Flags.SUMMARY, false,null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BStatusBooleanToBoolean#out
   */
  public boolean getOut() { return getBoolean(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BStatusBooleanToBoolean#out
   */
  public void setOut(boolean v) { setBoolean(out,v,null); }

////////////////////////////////////////////////////////////////
// Property "onNullInValue"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>onNullInValue</code> property.
   * @see com.tridium.kitControl.conversion.BStatusBooleanToBoolean#getOnNullInValue
   * @see com.tridium.kitControl.conversion.BStatusBooleanToBoolean#setOnNullInValue
   */
  public static final Property onNullInValue = newProperty(0, BNullValueOverrideSelect.useInValue,null);
  
  /**
   * Get the <code>onNullInValue</code> property.
   * @see com.tridium.kitControl.conversion.BStatusBooleanToBoolean#onNullInValue
   */
  public BNullValueOverrideSelect getOnNullInValue() { return (BNullValueOverrideSelect)get(onNullInValue); }
  
  /**
   * Set the <code>onNullInValue</code> property.
   * @see com.tridium.kitControl.conversion.BStatusBooleanToBoolean#onNullInValue
   */
  public void setOnNullInValue(BNullValueOverrideSelect v) { set(onNullInValue,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStatusBooleanToBoolean.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BStatusBooleanToBoolean()
  {
  }
  
  /**
   * Init if started after steady state has been reached.
   */
  public void started()
  {
    execute();
  }

  /**
   * set output on in change.
   */
  public void changed(Property p, Context cx)
  {
    if (!isRunning()) return;

    if( p.equals(in) )
    {
      execute();
    }
    else super.changed(p, cx);
  }

  public void execute()
  {
    setOut( ((BBoolean)calculate(getIn())).getBoolean());
  }

  public Type getOutType()
  {
    return BBoolean.TYPE;
  }
  
  public String toString(Context cx)
  {
    return BBoolean.make(getOut()).toString(cx);
  }

  /**
   * Apply the "facets" property to the "out" property.
   */
  public BFacets getSlotFacets(Slot slot)
  {
    if (slot == out) return getFacets();
    return super.getSlotFacets(slot);
  }

  public BFacets getOutFacets()
  {
    return getFacets();
  }

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/control.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  
}
