/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.conversion;

import javax.baja.log.Log;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

/**
 * @author    Bill Smith
 * @creation  18 June 2004
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */
public class BNumericUnitConverter
  extends BComponent
  implements BIStatus, BINumeric
{
  /*-
  
  class BNumericUnitConverter
  {
    properties
    {
      
      inFacets: BFacets
        -- These facets represent the in property
        default {[ BFacets.make(BFacets.UNITS, UnitDatabase.getUnit("null")) ]}
        
      in: BStatusNumeric
        flags { transient, summary }
        default {[ new BStatusNumeric() ]}

      outFacets: BFacets
        -- These facets represent the out property
        default {[ BFacets.make(BFacets.UNITS, UnitDatabase.getUnit("null")) ]}

      out: BStatusNumeric
        flags { transient, summary, readonly }
        default {[ new BStatusNumeric() ]}

    }

    actions
    {
      refresh()
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.conversion.BNumericUnitConverter(2046799079)1.0$ @*/
/* Generated Tue Sep 07 15:31:53 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "inFacets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inFacets</code> property.
   * These facets represent the in property
   * @see com.tridium.kitControl.conversion.BNumericUnitConverter#getInFacets
   * @see com.tridium.kitControl.conversion.BNumericUnitConverter#setInFacets
   */
  public static final Property inFacets = newProperty(0, BFacets.make(BFacets.UNITS, UnitDatabase.getUnit("null")),null);
  
  /**
   * Get the <code>inFacets</code> property.
   * @see com.tridium.kitControl.conversion.BNumericUnitConverter#inFacets
   */
  public BFacets getInFacets() { return (BFacets)get(inFacets); }
  
  /**
   * Set the <code>inFacets</code> property.
   * @see com.tridium.kitControl.conversion.BNumericUnitConverter#inFacets
   */
  public void setInFacets(BFacets v) { set(inFacets,v,null); }

////////////////////////////////////////////////////////////////
// Property "in"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BNumericUnitConverter#getIn
   * @see com.tridium.kitControl.conversion.BNumericUnitConverter#setIn
   */
  public static final Property in = newProperty(Flags.TRANSIENT|Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BNumericUnitConverter#in
   */
  public BStatusNumeric getIn() { return (BStatusNumeric)get(in); }
  
  /**
   * Set the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BNumericUnitConverter#in
   */
  public void setIn(BStatusNumeric v) { set(in,v,null); }

////////////////////////////////////////////////////////////////
// Property "outFacets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>outFacets</code> property.
   * These facets represent the out property
   * @see com.tridium.kitControl.conversion.BNumericUnitConverter#getOutFacets
   * @see com.tridium.kitControl.conversion.BNumericUnitConverter#setOutFacets
   */
  public static final Property outFacets = newProperty(0, BFacets.make(BFacets.UNITS, UnitDatabase.getUnit("null")),null);
  
  /**
   * Get the <code>outFacets</code> property.
   * @see com.tridium.kitControl.conversion.BNumericUnitConverter#outFacets
   */
  public BFacets getOutFacets() { return (BFacets)get(outFacets); }
  
  /**
   * Set the <code>outFacets</code> property.
   * @see com.tridium.kitControl.conversion.BNumericUnitConverter#outFacets
   */
  public void setOutFacets(BFacets v) { set(outFacets,v,null); }

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BNumericUnitConverter#getOut
   * @see com.tridium.kitControl.conversion.BNumericUnitConverter#setOut
   */
  public static final Property out = newProperty(Flags.TRANSIENT|Flags.SUMMARY|Flags.READONLY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BNumericUnitConverter#out
   */
  public BStatusNumeric getOut() { return (BStatusNumeric)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BNumericUnitConverter#out
   */
  public void setOut(BStatusNumeric v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Action "refresh"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>refresh</code> action.
   * @see com.tridium.kitControl.conversion.BNumericUnitConverter#refresh()
   */
  public static final Action refresh = newAction(0,null);
  
  /**
   * Invoke the <code>refresh</code> action.
   * @see com.tridium.kitControl.conversion.BNumericUnitConverter#refresh
   */
  public void refresh() { invoke(refresh,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BNumericUnitConverter.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BNumericUnitConverter()
  {
  }
  
  /**
   * Init if started after steady state has been reached.
   */
  public void started()
  {
    convert();
  }

  public void added(Property p, Context cx)
  {
    super.added(p, cx);
    if (!isRunning()) return;    
    if (checkLinkAdded())
    {
      syncSourceUnits();
    }
  }

  public void removed(Property p, BValue ov, Context cx)
  {
    super.removed(p, ov, cx);
    if (!isRunning()) return;
    checkLinkRemoved();
  }

  public void changed(Property p, Context cx)
  {
    super.changed(p, cx);
    if (!isRunning()) return;

    if (p == in || p == inFacets || p == outFacets)
    {
      convert();
    }
  }

  public void doRefresh()
  {
    syncSourceUnits();
  }

  public String toString(Context cx)
  {
    return getOut().toString(cx);
  }

  /**
   * Get the facets for the specified slot.
   */
  public BFacets getSlotFacets(Slot slot)
  {
    if (slot == in) return getInFacets();
    if (slot == out) return getOutFacets();
    return super.getSlotFacets(slot);
  }

  private synchronized boolean checkLinkRemoved()
  {
    BLink[] links = getLinks(in);
    if (links.length <= 0 && linked == true)
    {
      linked = false;
      return true;
    }
    
    return false;    
  }
  
  private synchronized boolean checkLinkAdded()
  {
    BLink[] links = getLinks(in);
    if (links.length > 0 && linked == false)
    {
      linked = true;
      return true;
    }
    
    return false;    
  }
  
  private synchronized void syncSourceUnits()
  {
    checkLinkAdded();
    if (linked)
    {
      BLink[] links = getLinks(in);
      if (links.length > 0)
      {
        Slot srcSlot = links[0].getSourceSlot();
        BComponent srcComponent = links[0].getSourceComponent();
        
        if (srcSlot != null && srcComponent != null)
        {
          BFacets srcFacets = srcComponent.getSlotFacets(srcSlot);          
          if (srcFacets != null)
          {
            setInFacets(srcFacets);
            setOutFacets(srcFacets);
          }        
        }
      }
    }
  }
  
  private void convert()
  {
    getOut().setStatus(getIn().getStatus());
    try
    {
      BUnit inUnit = (BUnit)getInFacets().get(BFacets.UNITS, BUnit.NULL);
      BUnit outUnit = (BUnit)getOutFacets().get(BFacets.UNITS, BUnit.NULL);

      double inValue = getIn().getValue();
      double outValue;

      if (inUnit.isNull() || outUnit.isNull() || inUnit == outUnit)
      {
        outValue = inValue;
      }
      else
      {
        outValue = inUnit.convertTo(outUnit, inValue);
      }

      getOut().setValue(outValue);
    }
    catch(Exception e)
    {
      getOut().setValue(getIn().getValue());
      getOut().setStatusFault(true);
    }
  }

////////////////////////////////////////////////////////////////
// BIStatus interface
////////////////////////////////////////////////////////////////

  public BStatus getStatus() { return getOut().getStatus(); }

////////////////////////////////////////////////////////////////
// BINumeric interface
////////////////////////////////////////////////////////////////

  public double getNumeric() { return getOut().getValue(); }

  public final BFacets getNumericFacets() { return getOutFacets(); }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/control.png");
  private boolean linked = false;

  public static Log log = Log.getLog("kitControl");
}
