/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.conversion;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.control.*;
import javax.baja.units.*;

/**
 * BFloatToStatusNumeric is a component that converts a float to a statusNumeric.
 *
 * @author    Andy Saunders
 * @creation  05 April 2004
 * @version   $Revision: 7$ $Date: 3/3/2004 8:48:19 AM$
 * @since     Baja 1.0
 */
public class BFloatToStatusNumeric
  extends BComponent
  implements BIStatus, BINumeric
{
  /*-
  
  class BFloatToStatusNumeric
  {
    properties
    {
      
      facets: BFacets
        -- These facets are applied against the out property.
        default {[ BFacets.make(BFacets.UNITS, BUnit.NULL, BFacets.PRECISION, BInteger.make(1) ) ]}
        
      out: BStatusNumeric
        flags { transient, readonly, summary }
        default {[ new BStatusNumeric() ]}

      in: float
        flags { transient, summary }
        default {[ 0.0f ]}

    }

    actions
    {
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.conversion.BFloatToStatusNumeric(2015981380)1.0$ @*/
/* Generated Wed Apr 27 10:19:55 EDT 2005 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "facets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>facets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.conversion.BFloatToStatusNumeric#getFacets
   * @see com.tridium.kitControl.conversion.BFloatToStatusNumeric#setFacets
   */
  public static final Property facets = newProperty(0, BFacets.make(BFacets.UNITS, BUnit.NULL, BFacets.PRECISION, BInteger.make(1) ),null);
  
  /**
   * Get the <code>facets</code> property.
   * @see com.tridium.kitControl.conversion.BFloatToStatusNumeric#facets
   */
  public BFacets getFacets() { return (BFacets)get(facets); }
  
  /**
   * Set the <code>facets</code> property.
   * @see com.tridium.kitControl.conversion.BFloatToStatusNumeric#facets
   */
  public void setFacets(BFacets v) { set(facets,v,null); }

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BFloatToStatusNumeric#getOut
   * @see com.tridium.kitControl.conversion.BFloatToStatusNumeric#setOut
   */
  public static final Property out = newProperty(Flags.TRANSIENT|Flags.READONLY|Flags.SUMMARY, new BStatusNumeric(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BFloatToStatusNumeric#out
   */
  public BStatusNumeric getOut() { return (BStatusNumeric)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BFloatToStatusNumeric#out
   */
  public void setOut(BStatusNumeric v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Property "in"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BFloatToStatusNumeric#getIn
   * @see com.tridium.kitControl.conversion.BFloatToStatusNumeric#setIn
   */
  public static final Property in = newProperty(Flags.TRANSIENT|Flags.SUMMARY, 0.0f,null);
  
  /**
   * Get the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BFloatToStatusNumeric#in
   */
  public float getIn() { return getFloat(in); }
  
  /**
   * Set the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BFloatToStatusNumeric#in
   */
  public void setIn(float v) { setFloat(in,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BFloatToStatusNumeric.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BFloatToStatusNumeric()
  {
  }
  
  /**
   * Init if started after steady state has been reached.
   */
  public void started()
  {
    getOut().setValue(getIn());
  }

/**
   * setoutput on in change.
   */
  public void changed(Property p, Context cx)
  {
    if (!isRunning()) return;

    if (p == in)
    {
      getOut().setValue(getIn());
    }
  }

  public String toString(Context cx)
  {
    return getOut().toString(cx);
  }

  /**
   * Apply the "facets" property to the "out" property.
   */
  public BFacets getSlotFacets(Slot slot)
  {
    if (slot == out) return getFacets();
    return super.getSlotFacets(slot);
  }

////////////////////////////////////////////////////////////////
// BIStatus interface
////////////////////////////////////////////////////////////////

  public BStatus getStatus() { return getOut().getStatus(); }

////////////////////////////////////////////////////////////////
// BINumeric interface
////////////////////////////////////////////////////////////////

  public double getNumeric() { return getOut().getValue(); }

  public final BFacets getNumericFacets() { return getFacets(); }


  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/control.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  
}
