/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.conversion;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.control.*;

/**
 * BBooleanToStatusBoolean is a component that converts a boolean to a statusBoolean.
 *
 * @author    Andy Saunders
 * @creation  05 April 2004
 * @version   $Revision: 7$ $Date: 3/3/2004 8:48:19 AM$
 * @since     Baja 1.0
 */
public class BBooleanToStatusBoolean
  extends BComponent
  implements BIStatus, BIBoolean
{
  /*-
  
  class BBooleanToStatusBoolean
  {
    properties
    {
      
      facets: BFacets
        -- These facets are applied against the out property.
        default {[ BFacets.makeBoolean() ]}
        
      in: boolean
        flags { transient, summary }
        default {[ false ]}

      out: BStatusBoolean
        flags { transient, readonly, summary }
        default {[ new BStatusBoolean() ]}

    }

    actions
    {
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.conversion.BBooleanToStatusBoolean(3875142005)1.0$ @*/
/* Generated Tue Nov 23 10:03:39 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "facets"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>facets</code> property.
   * These facets are applied against the out property.
   * @see com.tridium.kitControl.conversion.BBooleanToStatusBoolean#getFacets
   * @see com.tridium.kitControl.conversion.BBooleanToStatusBoolean#setFacets
   */
  public static final Property facets = newProperty(0, BFacets.makeBoolean(),null);
  
  /**
   * Get the <code>facets</code> property.
   * @see com.tridium.kitControl.conversion.BBooleanToStatusBoolean#facets
   */
  public BFacets getFacets() { return (BFacets)get(facets); }
  
  /**
   * Set the <code>facets</code> property.
   * @see com.tridium.kitControl.conversion.BBooleanToStatusBoolean#facets
   */
  public void setFacets(BFacets v) { set(facets,v,null); }

////////////////////////////////////////////////////////////////
// Property "in"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BBooleanToStatusBoolean#getIn
   * @see com.tridium.kitControl.conversion.BBooleanToStatusBoolean#setIn
   */
  public static final Property in = newProperty(Flags.TRANSIENT|Flags.SUMMARY, false,null);
  
  /**
   * Get the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BBooleanToStatusBoolean#in
   */
  public boolean getIn() { return getBoolean(in); }
  
  /**
   * Set the <code>in</code> property.
   * @see com.tridium.kitControl.conversion.BBooleanToStatusBoolean#in
   */
  public void setIn(boolean v) { setBoolean(in,v,null); }

////////////////////////////////////////////////////////////////
// Property "out"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BBooleanToStatusBoolean#getOut
   * @see com.tridium.kitControl.conversion.BBooleanToStatusBoolean#setOut
   */
  public static final Property out = newProperty(Flags.TRANSIENT|Flags.READONLY|Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BBooleanToStatusBoolean#out
   */
  public BStatusBoolean getOut() { return (BStatusBoolean)get(out); }
  
  /**
   * Set the <code>out</code> property.
   * @see com.tridium.kitControl.conversion.BBooleanToStatusBoolean#out
   */
  public void setOut(BStatusBoolean v) { set(out,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBooleanToStatusBoolean.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BBooleanToStatusBoolean()
  {
  }
  
  /**
   * Init if started after steady state has been reached.
   */
  public void started()
  {
    getOut().setValue(getIn());
  }

/**
   * setoutput on in change.
   */
  public void changed(Property p, Context cx)
  {
    if (!isRunning()) return;

    if (p == in)
    {
      getOut().setValue(getIn());
    }
  }

  public String toString(Context cx)
  {
    return getOut().toString(cx);
  }

  /**
   * Apply the "facets" property to the "out" property.
   */
  public BFacets getSlotFacets(Slot slot)
  {
    if (slot == out) return getFacets();
    return super.getSlotFacets(slot);
  }

////////////////////////////////////////////////////////////////
// BIStatus interface
////////////////////////////////////////////////////////////////

  public BStatus getStatus() { return getOut().getStatus(); }

////////////////////////////////////////////////////////////////
// BIBoolean interface
////////////////////////////////////////////////////////////////

  public boolean getBoolean() { return getOut().getValue(); }

  public final BFacets getBooleanFacets() { return getFacets(); }

  /**
   * Return the vaule as a enum.
   */
  public final BEnum getEnum() { return getOut().getEnum(); }

  /**
   * Return getFacets().
   */
  public final BFacets getEnumFacets() { return getFacets(); }



  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/control.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  
}
