/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl;

import javax.baja.naming.*;
import javax.baja.status.*;
import javax.baja.sys.*;
import javax.baja.util.*;
import com.tridium.kitControl.enums.*;


/**
 * BAlarmCountToRelay
 *
 * @author    JJ Frankovich
 * @creation  12 May 2006
 * @version   $Revision$ $Date$
 * @since     Niagara 3.2
*/
public class BAlarmCountToRelay
  extends BComponent
{

  /*-

  class BAlarmCountToRelay
  {
    properties
    {
      alarmCount: int
      flags { transient, fan_in }
      default {[ 0 ]}

      relayOut: BStatusBoolean
      flags { transient, readonly }
      default {[ new BStatusBoolean() ]}

      timer: BRelTime
      default {[ BRelTime.makeMinutes(2) ]}

      alarmCountType: BAlarmCountEnum
      --switching this value automates switching the links if not set to anyCount
      default {[ BAlarmCountEnum.anyCount ]}

    }
    actions
    {
      relayOutStop()
        flags { hidden }
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.kitControl.BAlarmCountToRelay(3771164204)1.0$ @*/
/* Generated Thu Feb 14 09:31:33 GMT-05:00 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "alarmCount"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>alarmCount</code> property.
   * @see com.tridium.kitControl.BAlarmCountToRelay#getAlarmCount
   * @see com.tridium.kitControl.BAlarmCountToRelay#setAlarmCount
   */
  public static final Property alarmCount = newProperty(Flags.TRANSIENT|Flags.FAN_IN, 0,null);
  
  /**
   * Get the <code>alarmCount</code> property.
   * @see com.tridium.kitControl.BAlarmCountToRelay#alarmCount
   */
  public int getAlarmCount() { return getInt(alarmCount); }
  
  /**
   * Set the <code>alarmCount</code> property.
   * @see com.tridium.kitControl.BAlarmCountToRelay#alarmCount
   */
  public void setAlarmCount(int v) { setInt(alarmCount,v,null); }

////////////////////////////////////////////////////////////////
// Property "relayOut"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>relayOut</code> property.
   * @see com.tridium.kitControl.BAlarmCountToRelay#getRelayOut
   * @see com.tridium.kitControl.BAlarmCountToRelay#setRelayOut
   */
  public static final Property relayOut = newProperty(Flags.TRANSIENT|Flags.READONLY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>relayOut</code> property.
   * @see com.tridium.kitControl.BAlarmCountToRelay#relayOut
   */
  public BStatusBoolean getRelayOut() { return (BStatusBoolean)get(relayOut); }
  
  /**
   * Set the <code>relayOut</code> property.
   * @see com.tridium.kitControl.BAlarmCountToRelay#relayOut
   */
  public void setRelayOut(BStatusBoolean v) { set(relayOut,v,null); }

////////////////////////////////////////////////////////////////
// Property "timer"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>timer</code> property.
   * @see com.tridium.kitControl.BAlarmCountToRelay#getTimer
   * @see com.tridium.kitControl.BAlarmCountToRelay#setTimer
   */
  public static final Property timer = newProperty(0, BRelTime.makeMinutes(2),null);
  
  /**
   * Get the <code>timer</code> property.
   * @see com.tridium.kitControl.BAlarmCountToRelay#timer
   */
  public BRelTime getTimer() { return (BRelTime)get(timer); }
  
  /**
   * Set the <code>timer</code> property.
   * @see com.tridium.kitControl.BAlarmCountToRelay#timer
   */
  public void setTimer(BRelTime v) { set(timer,v,null); }

////////////////////////////////////////////////////////////////
// Property "alarmCountType"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>alarmCountType</code> property.
   * switching this value automates switching the links
   * if not set to anyCount
   * @see com.tridium.kitControl.BAlarmCountToRelay#getAlarmCountType
   * @see com.tridium.kitControl.BAlarmCountToRelay#setAlarmCountType
   */
  public static final Property alarmCountType = newProperty(0, BAlarmCountEnum.anyCount,null);
  
  /**
   * Get the <code>alarmCountType</code> property.
   * @see com.tridium.kitControl.BAlarmCountToRelay#alarmCountType
   */
  public BAlarmCountEnum getAlarmCountType() { return (BAlarmCountEnum)get(alarmCountType); }
  
  /**
   * Set the <code>alarmCountType</code> property.
   * @see com.tridium.kitControl.BAlarmCountToRelay#alarmCountType
   */
  public void setAlarmCountType(BAlarmCountEnum v) { set(alarmCountType,v,null); }

////////////////////////////////////////////////////////////////
// Action "relayOutStop"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>relayOutStop</code> action.
   * @see com.tridium.kitControl.BAlarmCountToRelay#relayOutStop()
   */
  public static final Action relayOutStop = newAction(Flags.HIDDEN,null);
  
  /**
   * Invoke the <code>relayOutStop</code> action.
   * @see com.tridium.kitControl.BAlarmCountToRelay#relayOutStop
   */
  public void relayOutStop() { invoke(relayOutStop,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BAlarmCountToRelay.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BAlarmCountToRelay()
  {
  }

  public void started()
  {
    inputChange();
  }

  private int checkActive()
  {
    int total = 0;
    BLink[] links = getLinks(alarmCount);
    for(int i=0; i<links.length; i++)
    {
      if(links[i].isActive())
      {
        BComponent alarmClass = links[i].getSourceComponent();
        BInteger alarmCount = (BInteger) alarmClass.get(links[i].getSourceSlot().asProperty());
        if(alarmCount.getInt() > 0)
          total+=alarmCount.getInt();
      }
    }
    return total;
  }

  protected LinkCheck doCheckLink(BComponent source, Slot sourceSlot, Slot targetSlot, Context cx)
  {
    LinkCheck superCheck = super.doCheckLink(source, sourceSlot, targetSlot, cx);
    if(!superCheck.isValid() || getAlarmCountType().equals(BAlarmCountEnum.anyCount))
      return superCheck;

    if(!sourceSlot.getName().equals(getAlarmCountType().getTag()))
      return LinkCheck.makeInvalid("sourceSlot does not match AlarmCountType");
    else
      return LinkCheck.makeValid();
  }


  public void changed(Property p, Context cx)
  {
    if(!isRunning())
      return;

    if(p.equals(alarmCount))
    {
      inputChange();
    }
    else if(p.equals(timer))
    {
      totalAlarmCount = 0;
      inputChange();
    }
    else if(p.equals(alarmCountType))
    {
      if(!getAlarmCountType().equals(BAlarmCountEnum.anyCount))
      {
        BLink[] links = getLinks(alarmCount);
        for(int i=0; i<links.length; i++)
        {
          links[i].deactivate();
          links[i].setSourceSlotName(getAlarmCountType().getTag());
          links[i].activate();
        }
      }
      //reset
      totalAlarmCount = 0;
      inputChange();
    }
  }

  private void inputChange()
  {
    int active = checkActive();
    if(getTimer().equals(BRelTime.DEFAULT))
    {
      //untimed on
      getRelayOut().setValue( (active > 0) );
    }
    else
    {
      if(active > totalAlarmCount)
        turnOnRelay();
      else
        turnOffRelay();
      totalAlarmCount=active;
    }
  }

  private void turnOffRelay()
  {
    getRelayOut().setValue(false);
    if(relayStopTicket != null)
    {
      relayStopTicket.cancel();
      relayStopTicket=null;
    }
  }

  private void turnOnRelay()
  {
    getRelayOut().setValue(true);
    relayStopTicket = Clock.schedule(this, getTimer(), relayOutStop, null);
  }

  public void doRelayOutStop()
  {
    getRelayOut().setValue(false);
    relayStopTicket = null;
  }

  private Clock.Ticket relayStopTicket;
  private int totalAlarmCount = 0;
}

