/*
 * Copyright 2003 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.history.ext;

import javax.baja.sys.BAbsTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * An active period defines an active state by some time based criteria.
 *
 * @author    John Sublett
 * @creation  19 Nov 2004
 * @version   $Revision: 3$ $Date: 12/1/04 10:50:32 AM EST$
 * @since     Baja 1.0
 */
public abstract class BActivePeriod
  extends BStruct
{
  /*-

  class BActivePeriod
  {
    properties
    {
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.history.ext.BActivePeriod(3921686531)1.0$ @*/
/* Generated Thu Oct 23 07:14:36 EDT 2003 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BActivePeriod.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Does the active period always return true for isActive() with its current configuration?
   */
  public abstract boolean isAlwaysActive();

  /**
   * Does the active period always return false for isActive() with its current configuration?
   */
  public abstract boolean isNeverActive();

  /**
   * Returns true if the conditions for history collection to
   * be enabled are met, false otherwise.  Determination is based
   * on the given timestamp.
   */
  public abstract boolean isActive(BAbsTime timestamp);

  /**
   * Get the start time of the active period that includes the specified time.
   *
   * @param time A time that is included in the active period.  That is, isActive(time)
   *   return true.
   * @return Returns the start time of the period that includes the specified time.  If the
   *   specified time is not in an active period, null is returned.
   */
  public abstract BAbsTime getActiveStart(BAbsTime time);

  /**
   * Get the end time of the active period that includes the specified time.
   *
   * @param time A time that is included in the active period.  That is, isActive(time)
   *   return true.
   * @return Returns the end time of the period that includes the specified time.  If the
   *   specified time is not in an active period, null is returned.
   */
  public abstract BAbsTime getActiveEnd(BAbsTime time);

  /**
   * Get the start of the next active period
   */
  public abstract BAbsTime getNextActive(BAbsTime time);

  /**
   * Get the end of the next active period.  If the specified
   * time is in an active period, the end of the period is returned.
   * If the specified time is not in an effective period, the
   * end of the next active period is returned.
   */
  public abstract BAbsTime getNextInactive(BAbsTime time);

}
