/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.history;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BStorageType specifies the storage mechanism for the records in
 * a BHistory.
 *
 * @author    John Sublett
 * @creation  2 July 2002
 * @version   $Revision: 4$ $Date: 3/31/04 11:50:48 AM EST$
 * @since     Baja 1.0
 */
public final class BStorageType
  extends BFrozenEnum
{

  /*-

  enum BStorageType
  {
    range
    {
      file,
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.history.BStorageType(3114085378)1.0$ @*/
/* Generated Sun Jan 08 10:47:05 EST 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

  /** Ordinal value for file. */
  public static final int FILE = 0;

  /** BStorageType constant for file. */
  public static final BStorageType file = new BStorageType(FILE);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStorageType.class);

  /** Factory method with ordinal. */
  public static BStorageType make(int ordinal)
  {
    return (BStorageType)file.getRange().get(ordinal, false);
  }

  /** Factory method with tag. */
  public static BStorageType make(String tag)
  {
    return (BStorageType)file.getRange().get(tag);
  }

  /** Private constructor. */
  private BStorageType(int ordinal)
  {
    super(ordinal);
  }

  public static final BStorageType DEFAULT = BStorageType.file;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

}

