/**
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.history;

import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

/**
 * BRolloverValue is used to specify a rollover value (i.e. min or max) for
 * a numeric history to support delta logging.  The value can be null (unspecified),
 * which means that no rollover value is defined.
 *
 * @author    Scott Hoye
 * @creation  12 May 05
 * @version   $Revision: 2$ $Date: 5/23/05 1:34:16 PM EDT$
 * @since     Baja 1.0
 */
public final class BRolloverValue
  extends BStruct
{
  /*-

  class BRolloverValue
  {
    properties
    {
      unspecified : boolean
        -- True if unspecified, false if the value field is valid.
        default {[ true ]}

      value : double
        -- The rollover value.
        default {[ 0.0 ]}
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.history.BRolloverValue(1969024881)1.0$ @*/
/* Generated Sun Jan 08 10:47:05 EST 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "unspecified"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>unspecified</code> property.
   * True if unspecified, false if the value field is valid.
   * @see javax.baja.history.BRolloverValue#getUnspecified
   * @see javax.baja.history.BRolloverValue#setUnspecified
   */
  public static final Property unspecified = newProperty(0, true,null);

  /**
   * Get the <code>unspecified</code> property.
   * True if unspecified, false if the value field is valid.
   * @see javax.baja.history.BRolloverValue#unspecified
   */
  public boolean getUnspecified() { return getBoolean(unspecified); }

  /**
   * Set the <code>unspecified</code> property.
   * True if unspecified, false if the value field is valid.
   * @see javax.baja.history.BRolloverValue#unspecified
   */
  public void setUnspecified(boolean v) { setBoolean(unspecified,v,null); }

////////////////////////////////////////////////////////////////
// Property "value"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>value</code> property.
   * The rollover value.
   * @see javax.baja.history.BRolloverValue#getValue
   * @see javax.baja.history.BRolloverValue#setValue
   */
  public static final Property value = newProperty(0, 0.0,null);

  /**
   * Get the <code>value</code> property.
   * The rollover value.
   * @see javax.baja.history.BRolloverValue#value
   */
  public double getValue() { return getDouble(value); }

  /**
   * Set the <code>value</code> property.
   * The rollover value.
   * @see javax.baja.history.BRolloverValue#value
   */
  public void setValue(double v) { setDouble(value,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BRolloverValue.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  @Override
  public String toString(Context cx)
  {
    if (getUnspecified())
      return unspecifiedTxt.getText(cx);
    else
      return Double.toString(getValue());
  }

///////////////////////////////////////////////////////////
// Attributes
///////////////////////////////////////////////////////////

  private static final LexiconText unspecifiedTxt = LexiconText.make("history", "rollover.unspecified");

}

