/**
 * Copyright 2009 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.history;

import java.util.Map;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInterface;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BNameList;
import com.tridium.sys.schema.Fw;

/**
 * BHistoryGroup is used to specify a history group definition for
 * organizing histories in the nav tree.
 *
 * @author    Scott Hoye
 * @creation  15 Sep 09
 * @version   $Revision: 1$ $Date: 10/2/09 12:43:15 PM EDT$
 * @since     Niagara 3.5
 */
public final class BHistoryGroup
  extends BComponent
{
  /*-

  class BHistoryGroup
  {
    properties
    {
      enabled: boolean
        -- Enabled is used to manually enable/disable this history group.
        default {[ true ]}

      historyPropertiesToGroupBy : BNameList
        -- The names of history properties to organize histories by for this history group.
        default {[ BNameList.DEFAULT ]}
        slotfacets{[ FIELD_EDITOR="workbench:GenericNameListFE" ]}
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.history.BHistoryGroup(1214464582)1.0$ @*/
/* Generated Sun Jan 08 10:47:05 EST 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "enabled"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>enabled</code> property.
   * Enabled is used to manually enable/disable this history
   * group.
   * @see javax.baja.history.BHistoryGroup#getEnabled
   * @see javax.baja.history.BHistoryGroup#setEnabled
   */
  public static final Property enabled = newProperty(0, true,null);

  /**
   * Get the <code>enabled</code> property.
   * Enabled is used to manually enable/disable this history
   * group.
   * @see javax.baja.history.BHistoryGroup#enabled
   */
  public boolean getEnabled() { return getBoolean(enabled); }

  /**
   * Set the <code>enabled</code> property.
   * Enabled is used to manually enable/disable this history
   * group.
   * @see javax.baja.history.BHistoryGroup#enabled
   */
  public void setEnabled(boolean v) { setBoolean(enabled,v,null); }

////////////////////////////////////////////////////////////////
// Property "historyPropertiesToGroupBy"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>historyPropertiesToGroupBy</code> property.
   * The names of history properties to organize histories
   * by for this history group.
   * @see javax.baja.history.BHistoryGroup#getHistoryPropertiesToGroupBy
   * @see javax.baja.history.BHistoryGroup#setHistoryPropertiesToGroupBy
   */
  public static final Property historyPropertiesToGroupBy = newProperty(0, BNameList.DEFAULT,BFacets.make(BFacets.FIELD_EDITOR,"workbench:GenericNameListFE"));

  /**
   * Get the <code>historyPropertiesToGroupBy</code> property.
   * The names of history properties to organize histories
   * by for this history group.
   * @see javax.baja.history.BHistoryGroup#historyPropertiesToGroupBy
   */
  public BNameList getHistoryPropertiesToGroupBy() { return (BNameList)get(historyPropertiesToGroupBy); }

  /**
   * Set the <code>historyPropertiesToGroupBy</code> property.
   * The names of history properties to organize histories
   * by for this history group.
   * @see javax.baja.history.BHistoryGroup#historyPropertiesToGroupBy
   */
  public void setHistoryPropertiesToGroupBy(BNameList v) { set(historyPropertiesToGroupBy,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BHistoryGroup.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Component overrides
////////////////////////////////////////////////////////////////

  /**
   * Never allow child components on a history group
   */
  @Override
  public boolean isChildLegal(BComponent child)
  {
    return false;
  }

  /**
   * Callback when a property (or possibly a descendent of
   * that property) is modified on this component via
   * one of the <code>set</code> methods.
   */
  @Override
  public void changed(Property property, Context context)
  {
    super.changed(property, context);

    if (isRunning() && (property != null) && (property.isFrozen()))
    {
      // Whenever changed, clear the history space's folder cache
      BHistoryService service = (BHistoryService)Sys.getService(BHistoryService.TYPE);
      BHistoryDatabase space = service.getDatabase();
      if (space != null)
      {
        @SuppressWarnings("unchecked") Map<BInterface, Map<String, BINavNode>> folderCache =
          (Map<BInterface, Map<String, BINavNode>>)space.fw(Fw.USER_DEFINED_4);
        if (folderCache != null) folderCache.clear();
      }
    }
  }

////////////////////////////////////////////////////////////////
// Icon
////////////////////////////////////////////////////////////////

  private static final BIcon icon = BIcon.std("historyGroup.png");
  @Override
  public BIcon getIcon() { return icon; }

}

