/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package javax.baja.history;

import java.io.IOException;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BNameList;
import javax.baja.util.BTypeSpec;

/**
 * BHistoryConfig is the configuration for a history in the
 * history database.
 *
 * @author    John Sublett
 * @creation  02 Apr 2003
 * @version   $Revision: 24$ $Date: 5/22/08 2:41:23 PM EDT$
 * @since     Baja 1.0
 */
public class BHistoryConfig
  extends BComponent
{
  /*-

  class BHistoryConfig
  {
    properties
    {
      id: BHistoryId
        -- The unique identifier for this history within the
        -- entire system.
        flags { defaultOnClone, summary, operator, readonly }
        default {[ BHistoryId.NULL ]}

      historyName: String
        -- Temporary for the transition from the old historyName
        -- scheme.  Will be removed before the final release.
        flags { hidden, transient }
        default {[ "" ]}

      source: BOrdList
        -- The list of ords that identifies the original source
        -- of the history.  For a history, the ord list indicates
        -- the path that the history has moved through the system
        -- via the archive mechanism.  The history in the source
        -- device will have an ord list of length 1.
        flags { summary, operator, readonly }
        default {[ BOrdList.NULL ]}

      sourceHandle: BOrd
        -- The handle for the source of this history in the station
        -- that originally created it.
        flags { hidden }
        default {[ BOrd.NULL ]}

      timeZone: BTimeZone
        -- The timezone where this history was originally collected.
        flags { defaultOnClone, readonly }
        default {[ BTimeZone.NULL ]}

      recordType: BTypeSpec
        -- The type spec for the records in the history.
        flags { readonly }
        default {[ BTypeSpec.NULL ]}

      schema: BHistorySchema
        -- The schema for the record.  This allows the history
        -- to be read even if the original record type class
        -- has changed or is not available.
        flags { readonly, hidden }
        default {[ BHistorySchema.DEFAULT ]}

      capacity: BCapacity
        -- The amount of data that can be stored in the history.  The capacity
        -- can be defined either by record count or by storage size.
        default {[ BCapacity.makeByRecordCount(500) ]}

      fullPolicy: BFullPolicy
        -- This defines the behavior when an attempt is made to write records
        -- to a history with limited capacity that is full.
        default {[ BFullPolicy.roll ]}

      storageType: BStorageType
        -- This defines the mechanism for storage of the history records.
        flags { hidden }
        default {[ BStorageType.file ]}

      interval: BCollectionInterval
        -- The amount of time between records in the history.
        flags { operator, readonly }
        default {[ BCollectionInterval.IRREGULAR ]}

      systemTags: BNameList
        -- Contains a list of system tag names (each tag
        -- is separated by a semicolon) that can be used to identify
        -- the history as part of a system (or part of multiple systems).
        --  @since Niagara 3.4
        default {[ BNameList.NULL ]}
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.history.BHistoryConfig(2073268838)1.0$ @*/
/* Generated Sun Jan 08 10:47:05 EST 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "id"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>id</code> property.
   * The unique identifier for this history within the entire system.
   * @see javax.baja.history.BHistoryConfig#getId
   * @see javax.baja.history.BHistoryConfig#setId
   */
  public static final Property id = newProperty(Flags.DEFAULT_ON_CLONE|Flags.SUMMARY|Flags.OPERATOR|Flags.READONLY, BHistoryId.NULL,null);

  /**
   * Get the <code>id</code> property.
   * The unique identifier for this history within the entire system.
   * @see javax.baja.history.BHistoryConfig#id
   */
  public BHistoryId getId() { return (BHistoryId)get(id); }

  /**
   * Set the <code>id</code> property.
   * The unique identifier for this history within the entire system.
   * @see javax.baja.history.BHistoryConfig#id
   */
  public void setId(BHistoryId v) { set(id,v,null); }

////////////////////////////////////////////////////////////////
// Property "historyName"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>historyName</code> property.
   * Temporary for the transition from the old historyName
   * scheme.  Will be removed before the final release.
   * @see javax.baja.history.BHistoryConfig#getHistoryName
   * @see javax.baja.history.BHistoryConfig#setHistoryName
   */
  public static final Property historyName = newProperty(Flags.HIDDEN|Flags.TRANSIENT, "",null);

  /**
   * Get the <code>historyName</code> property.
   * Temporary for the transition from the old historyName
   * scheme.  Will be removed before the final release.
   * @see javax.baja.history.BHistoryConfig#historyName
   */
  public String getHistoryName() { return getString(historyName); }

  /**
   * Set the <code>historyName</code> property.
   * Temporary for the transition from the old historyName
   * scheme.  Will be removed before the final release.
   * @see javax.baja.history.BHistoryConfig#historyName
   */
  public void setHistoryName(String v) { setString(historyName,v,null); }

////////////////////////////////////////////////////////////////
// Property "source"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>source</code> property.
   * The list of ords that identifies the original source
   * of the history.  For a history, the ord list indicates
   * the path that the history has moved through the system
   * via the archive mechanism.  The history in the source
   * device will have an ord list of length 1.
   * @see javax.baja.history.BHistoryConfig#getSource
   * @see javax.baja.history.BHistoryConfig#setSource
   */
  public static final Property source = newProperty(Flags.SUMMARY|Flags.OPERATOR|Flags.READONLY, BOrdList.NULL,null);

  /**
   * Get the <code>source</code> property.
   * The list of ords that identifies the original source
   * of the history.  For a history, the ord list indicates
   * the path that the history has moved through the system
   * via the archive mechanism.  The history in the source
   * device will have an ord list of length 1.
   * @see javax.baja.history.BHistoryConfig#source
   */
  public BOrdList getSource() { return (BOrdList)get(source); }

  /**
   * Set the <code>source</code> property.
   * The list of ords that identifies the original source
   * of the history.  For a history, the ord list indicates
   * the path that the history has moved through the system
   * via the archive mechanism.  The history in the source
   * device will have an ord list of length 1.
   * @see javax.baja.history.BHistoryConfig#source
   */
  public void setSource(BOrdList v) { set(source,v,null); }

////////////////////////////////////////////////////////////////
// Property "sourceHandle"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>sourceHandle</code> property.
   * The handle for the source of this history in the station
   * that originally created it.
   * @see javax.baja.history.BHistoryConfig#getSourceHandle
   * @see javax.baja.history.BHistoryConfig#setSourceHandle
   */
  public static final Property sourceHandle = newProperty(Flags.HIDDEN, BOrd.NULL,null);

  /**
   * Get the <code>sourceHandle</code> property.
   * The handle for the source of this history in the station
   * that originally created it.
   * @see javax.baja.history.BHistoryConfig#sourceHandle
   */
  public BOrd getSourceHandle() { return (BOrd)get(sourceHandle); }

  /**
   * Set the <code>sourceHandle</code> property.
   * The handle for the source of this history in the station
   * that originally created it.
   * @see javax.baja.history.BHistoryConfig#sourceHandle
   */
  public void setSourceHandle(BOrd v) { set(sourceHandle,v,null); }

////////////////////////////////////////////////////////////////
// Property "timeZone"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>timeZone</code> property.
   * The timezone where this history was originally collected.
   * @see javax.baja.history.BHistoryConfig#getTimeZone
   * @see javax.baja.history.BHistoryConfig#setTimeZone
   */
  public static final Property timeZone = newProperty(Flags.DEFAULT_ON_CLONE|Flags.READONLY, BTimeZone.NULL,null);

  /**
   * Get the <code>timeZone</code> property.
   * The timezone where this history was originally collected.
   * @see javax.baja.history.BHistoryConfig#timeZone
   */
  public BTimeZone getTimeZone() { return (BTimeZone)get(timeZone); }

  /**
   * Set the <code>timeZone</code> property.
   * The timezone where this history was originally collected.
   * @see javax.baja.history.BHistoryConfig#timeZone
   */
  public void setTimeZone(BTimeZone v) { set(timeZone,v,null); }

////////////////////////////////////////////////////////////////
// Property "recordType"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>recordType</code> property.
   * The type spec for the records in the history.
   * @see javax.baja.history.BHistoryConfig#getRecordType
   * @see javax.baja.history.BHistoryConfig#setRecordType
   */
  public static final Property recordType = newProperty(Flags.READONLY, BTypeSpec.NULL,null);

  /**
   * Get the <code>recordType</code> property.
   * The type spec for the records in the history.
   * @see javax.baja.history.BHistoryConfig#recordType
   */
  public BTypeSpec getRecordType() { return (BTypeSpec)get(recordType); }

  /**
   * Set the <code>recordType</code> property.
   * The type spec for the records in the history.
   * @see javax.baja.history.BHistoryConfig#recordType
   */
  public void setRecordType(BTypeSpec v) { set(recordType,v,null); }

////////////////////////////////////////////////////////////////
// Property "schema"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>schema</code> property.
   * The schema for the record.  This allows the history
   * to be read even if the original record type class has changed or is not available.
   * @see javax.baja.history.BHistoryConfig#getSchema
   * @see javax.baja.history.BHistoryConfig#setSchema
   */
  public static final Property schema = newProperty(Flags.READONLY|Flags.HIDDEN, BHistorySchema.DEFAULT,null);

  /**
   * Get the <code>schema</code> property.
   * The schema for the record.  This allows the history
   * to be read even if the original record type class has changed or is not available.
   * @see javax.baja.history.BHistoryConfig#schema
   */
  public BHistorySchema getSchema() { return (BHistorySchema)get(schema); }

  /**
   * Set the <code>schema</code> property.
   * The schema for the record.  This allows the history
   * to be read even if the original record type class has changed or is not available.
   * @see javax.baja.history.BHistoryConfig#schema
   */
  public void setSchema(BHistorySchema v) { set(schema,v,null); }

////////////////////////////////////////////////////////////////
// Property "capacity"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>capacity</code> property.
   * The amount of data that can be stored in the history.
   *  The capacity can be defined either by record count
   * or by storage size.
   * @see javax.baja.history.BHistoryConfig#getCapacity
   * @see javax.baja.history.BHistoryConfig#setCapacity
   */
  public static final Property capacity = newProperty(0, BCapacity.makeByRecordCount(500),null);

  /**
   * Get the <code>capacity</code> property.
   * The amount of data that can be stored in the history.
   *  The capacity can be defined either by record count
   * or by storage size.
   * @see javax.baja.history.BHistoryConfig#capacity
   */
  public BCapacity getCapacity() { return (BCapacity)get(capacity); }

  /**
   * Set the <code>capacity</code> property.
   * The amount of data that can be stored in the history.
   *  The capacity can be defined either by record count
   * or by storage size.
   * @see javax.baja.history.BHistoryConfig#capacity
   */
  public void setCapacity(BCapacity v) { set(capacity,v,null); }

////////////////////////////////////////////////////////////////
// Property "fullPolicy"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>fullPolicy</code> property.
   * This defines the behavior when an attempt is made to write records to a history with limited capacity that is full.
   * @see javax.baja.history.BHistoryConfig#getFullPolicy
   * @see javax.baja.history.BHistoryConfig#setFullPolicy
   */
  public static final Property fullPolicy = newProperty(0, BFullPolicy.roll,null);

  /**
   * Get the <code>fullPolicy</code> property.
   * This defines the behavior when an attempt is made to write records to a history with limited capacity that is full.
   * @see javax.baja.history.BHistoryConfig#fullPolicy
   */
  public BFullPolicy getFullPolicy() { return (BFullPolicy)get(fullPolicy); }

  /**
   * Set the <code>fullPolicy</code> property.
   * This defines the behavior when an attempt is made to write records to a history with limited capacity that is full.
   * @see javax.baja.history.BHistoryConfig#fullPolicy
   */
  public void setFullPolicy(BFullPolicy v) { set(fullPolicy,v,null); }

////////////////////////////////////////////////////////////////
// Property "storageType"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>storageType</code> property.
   * This defines the mechanism for storage of the history
   * records.
   * @see javax.baja.history.BHistoryConfig#getStorageType
   * @see javax.baja.history.BHistoryConfig#setStorageType
   */
  public static final Property storageType = newProperty(Flags.HIDDEN, BStorageType.file,null);

  /**
   * Get the <code>storageType</code> property.
   * This defines the mechanism for storage of the history
   * records.
   * @see javax.baja.history.BHistoryConfig#storageType
   */
  public BStorageType getStorageType() { return (BStorageType)get(storageType); }

  /**
   * Set the <code>storageType</code> property.
   * This defines the mechanism for storage of the history
   * records.
   * @see javax.baja.history.BHistoryConfig#storageType
   */
  public void setStorageType(BStorageType v) { set(storageType,v,null); }

////////////////////////////////////////////////////////////////
// Property "interval"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>interval</code> property.
   * The amount of time between records in the history.
   * @see javax.baja.history.BHistoryConfig#getInterval
   * @see javax.baja.history.BHistoryConfig#setInterval
   */
  public static final Property interval = newProperty(Flags.OPERATOR|Flags.READONLY, BCollectionInterval.IRREGULAR,null);

  /**
   * Get the <code>interval</code> property.
   * The amount of time between records in the history.
   * @see javax.baja.history.BHistoryConfig#interval
   */
  public BCollectionInterval getInterval() { return (BCollectionInterval)get(interval); }

  /**
   * Set the <code>interval</code> property.
   * The amount of time between records in the history.
   * @see javax.baja.history.BHistoryConfig#interval
   */
  public void setInterval(BCollectionInterval v) { set(interval,v,null); }

////////////////////////////////////////////////////////////////
// Property "systemTags"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>systemTags</code> property.
   * Contains a list of system tag names (each tag is separated
   * by a semicolon) that can be used to identify the history
   * as part of a system (or part of multiple systems).
   * @since Niagara 3.4
   * @see javax.baja.history.BHistoryConfig#getSystemTags
   * @see javax.baja.history.BHistoryConfig#setSystemTags
   */
  public static final Property systemTags = newProperty(0, BNameList.NULL,null);

  /**
   * Get the <code>systemTags</code> property.
   * Contains a list of system tag names (each tag is separated
   * by a semicolon) that can be used to identify the history
   * as part of a system (or part of multiple systems).
   * @since Niagara 3.4
   * @see javax.baja.history.BHistoryConfig#systemTags
   */
  public BNameList getSystemTags() { return (BNameList)get(systemTags); }

  /**
   * Set the <code>systemTags</code> property.
   * Contains a list of system tag names (each tag is separated
   * by a semicolon) that can be used to identify the history
   * as part of a system (or part of multiple systems).
   * @since Niagara 3.4
   * @see javax.baja.history.BHistoryConfig#systemTags
   */
  public void setSystemTags(BNameList v) { set(systemTags,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BHistoryConfig.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BHistoryConfig()
  {
  }

  public BHistoryConfig(BHistoryId id, BTypeSpec recType)
  {
    setId(id);
    setRecordType(recType);
    setSchema(makeRecord(recType, BHistoryRecord.VERSION_2).getSchema());
  }

  public BHistoryConfig(BCapacity capacity, BFullPolicy fullPolicy)
  {
    setCapacity(capacity);
    setFullPolicy(fullPolicy);
  }

  public BHistoryConfig(BHistoryId id,
                        BTypeSpec  recordType,
                        BCapacity  capacity)
  {
    setId(id);
    setRecordType(recordType);
    setSchema(makeRecord(recordType, BHistoryRecord.VERSION_2).getSchema());
    setCapacity(capacity);
  }


  /**
   * Get the type for the column with the specified name.
   *
   * @param name The name of the column.
   * @return Returns the type of the target column or null if the column does
   *   not exist.
   */
  public Type getColumnType(String name)
  {
    try
    {
      BHistoryRecord rec = makeRecord();
      Property prop = rec.getProperty(name);
      if (prop == null)
        return null;
      else
        return prop.getDefaultValue().getType();
    }
    catch(Exception e)
    {
      return null;
    }
  }

  /**
   * Make a template record.  This creates a new instance with default values.
   *
   * @return The template record.
   */
  public BHistoryRecord makeRecord()
    throws HistoryException
  {
    return makeRecord(BHistoryRecord.VERSION_2);
  }

  public BHistoryRecord makeRecord(int version)
    throws HistoryException
  {
    BTypeSpec recordType = getRecordType();
    try
    {
      return makeRecord(recordType, version);
    }
    catch (TypeNotFoundException ex)
    {
      // TODO - Temporary for Float -> Numeric transition
      if (recordType.getTypeName().equals("FloatTrendRecord"))
      {
        setRecordType(BNumericTrendRecord.TYPE.getTypeSpec());
        return new BNumericTrendRecord();
      }
      else
        throw ex;
    }
  }

  /**
   * Create an instance of the specified type.
   */
  private static BHistoryRecord makeRecord(BTypeSpec typeSpec, int version)
  {
    Type recordType = typeSpec.getResolvedType();
    BHistoryRecord record = (BHistoryRecord)recordType.getInstance();
    record.setHistoryVersion(version);
    return record;
  }

  /**
   * Make a prototype record for the relation.
   */
  public BObject makePrototype()
  {
    try
    {
      return makeRecord();
    }
    catch(Exception e)
    {
      throw new BajaRuntimeException(e);
    }
  }

  /**
   * Get the size of the records in this history.  If the record size is not
   * fixed an UnsupportedOperationException is thrown.
   *
   * @exception UnsupportedOperationException Thrown if the record size is not fixed.
   */
  public int getRecordSize()
    throws IOException, HistoryException
  {
    if (recordSize == -1)
    {
      try
      {
        BHistoryRecord rec = makeRecord();
        if (!rec.isFixedSize())
          throw new UnsupportedOperationException
            ("A fixed record size cannot be determined for" +
             " a history with variable length records.");

        recordSize = rec.getRecordSize();
      }
      catch(ModuleException e)
      {
        throw new HistoryException(e.getMessage(), e);
      }
      catch(TypeException e)
      {
        throw new HistoryException(e.getMessage(), e);
      }
    }

    return recordSize;
  }

  /**
   * Handle a property change.
   */
  @Override
  public void changed(Property p, Context c)
  {
    if (c == Context.decoding) return;

    // Init the schema if necessary
    if (p == recordType)
    {
      if (getSchema().equals(BHistorySchema.DEFAULT))
        setSchema(makeRecord().getSchema());
    }

    if (!isRunning()) return;

    BComplex parent = getParent();
    if (parent instanceof BIHistorySource)
      ((BIHistorySource)parent).historyConfigChanged(this, p);
  }

  /**
   * Handle a property addition.
   */
  @Override
  public void added(Property p, Context c)
  {
    if (c == Context.decoding) return;
    if (!isRunning()) return;

    BComplex parent = getParent();
    if (parent instanceof BIHistorySource)
      ((BIHistorySource)parent).historyConfigChanged(this, p);
  }

  /**
   * Handle a property removal.
   */
  @Override
  public void removed(Property p, BValue value, Context c)
  {
    if (c == Context.decoding) return;
    if (!isRunning()) return;

    BComplex parent = getParent();
    if (parent instanceof BIHistorySource)
      ((BIHistorySource)parent).historyConfigChanged(this, p);
  }

  /**
   * Called when an existing property is renamed via one
   * of the <code>rename</code> methods.
   */
  @Override
  public void renamed(Property p, String oldName, Context c)
  {
    if (c == Context.decoding) return;
    if (!isRunning()) return;

    BComplex parent = getParent();
    if (parent instanceof BIHistorySource)
      ((BIHistorySource)parent).historyConfigChanged(this, p);
  }

  /**
   * Called when a slot's flags are modified via one of
   * the <code>setFlags</code> methods.
   */
  @Override
  public void flagsChanged(Slot slot, Context c)
  {
    if (c == Context.decoding) return;
    if (!isRunning()) return;
    if (!slot.isProperty()) return;

    BComplex parent = getParent();
    if (parent instanceof BIHistorySource)
      ((BIHistorySource)parent).historyConfigChanged(this, slot.asProperty());
  }

  /**
   * Called when a slot's facets are modified via one of
   * the <code>setFacets</code> methods.
   */
  @Override
  public void facetsChanged(Slot slot, Context c)
  {
    if (c == Context.decoding) return;
    if (!isRunning()) return;
    if (!slot.isProperty()) return;

    BComplex parent = getParent();
    if (parent instanceof BIHistorySource)
      ((BIHistorySource)parent).historyConfigChanged(this, slot.asProperty());
  }

  @Override
  public String toString(Context cx)
  {
    StringBuffer out = new StringBuffer();
    out.append(BHistoryConfig.interval.getDefaultDisplayName(cx)+": "+getInterval()).append(", ");
    out.append(BHistoryConfig.recordType.getDefaultDisplayName(cx)+": ");
    out.append(getRecordType().isNull() ? "null" : getRecordType().getResolvedType().getDisplayName(cx).toLowerCase()).append(", ");
    out.append(BHistoryConfig.capacity.getDefaultDisplayName(cx)+": "+getCapacity()).append(", ");
    out.append(BHistoryConfig.fullPolicy.getDefaultDisplayName(cx)+": "+getFullPolicy());
    return out.toString();
  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  private int recordSize = -1;
  private BHistoryRecord prototype;

}