/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.history;

import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BFullPolicy defines the behavior of a history when the
 * capacity is limited, the history is full, and an attempt
 * is made to write new records.
 *
 * @author    John Sublett
 * @creation  20 Jun 2002
 * @version   $Revision: 4$ $Date: 3/31/04 11:50:44 AM EST$
 * @since     Baja 1.0
 */
public final class BFullPolicy
  extends BFrozenEnum
{
  /*-

  enum BFullPolicy
  {
    range
    {
      stop,
      roll,
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.history.BFullPolicy(3270411252)1.0$ @*/
/* Generated Sun Jan 08 10:47:05 EST 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

  /** Ordinal value for stop. */
  public static final int STOP = 0;
  /** Ordinal value for roll. */
  public static final int ROLL = 1;

  /** BFullPolicy constant for stop. */
  public static final BFullPolicy stop = new BFullPolicy(STOP);
  /** BFullPolicy constant for roll. */
  public static final BFullPolicy roll = new BFullPolicy(ROLL);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BFullPolicy.class);

  /** Factory method with ordinal. */
  public static BFullPolicy make(int ordinal)
  {
    return (BFullPolicy)stop.getRange().get(ordinal, false);
  }

  /** Factory method with tag. */
  public static BFullPolicy make(String tag)
  {
    return (BFullPolicy)stop.getRange().get(tag);
  }

  /** Private constructor. */
  private BFullPolicy(int ordinal)
  {
    super(ordinal);
  }

  public static final BFullPolicy DEFAULT = BFullPolicy.stop;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

}

