/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.flexSerial.ui;

import javax.baja.naming.*;
import javax.baja.sys.*;
import javax.baja.util.*;
import javax.baja.alarm.*;
 
import javax.baja.workbench.*; 
import com.tridium.workbench.fieldeditors.*;

import com.tridium.flexSerial.*;
import com.tridium.flexSerial.messages.*;

/**
 * Plugin for BString when used as an messageElement identifier.
 *
 * @author    Andy Saunders
 * @creation  15 Sept 2005
 * @version   $Revision$ $Date: 2/15/2005 12:58:34 PM$
 * @since     Baja 1.0
 */
public class BFlexMessageElementSelectFE
  extends BComponentNamePickerFE
{ 

////////////////////////////////////////////////////////////////
// BObject 
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BFlexMessageElementSelectFE.class);

////////////////////////////////////////////////////////////////
// BPlugin
////////////////////////////////////////////////////////////////

  protected void doLoadValue(BObject value, Context cx)
  {
    elementName = (BFlexMessageElementName)value; 
    responseMessage = (BFlexResponseMessage) elementName.getParent();
    loadName(elementName.getElementSelect());
  }
  
  protected BObject doSaveValue(BObject value, Context cx)
  {
    elementName.setElementSelect(saveName());
    return elementName;
  }
  


  

  
  public BComponent[] list()
    throws Exception
  {

    BFlexMessageBlock msg = (BFlexMessageBlock)responseMessage.get("instance");
    msg.lease();
    return (BComponent[])msg.getChildren(BFlexMessageElement.class);
  }
  
  BFlexMessageElementName elementName;
  BFlexResponseMessage responseMessage;

}
