/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.flexSerial.ui;

import javax.baja.sys.*;
import javax.baja.util.*;
import javax.baja.ui.*;
import javax.baja.ui.enums.*;
import javax.baja.ui.options.*;
import javax.baja.ui.pane.*;
import com.tridium.workbench.fieldeditors.*;
import com.tridium.workbench.fieldeditors.facets.*;

/**
 * BFlexFacetsFE allows viewing and editing of BFacets for FlexSerial.
 *
 * @author    Andy Saunders       
 * @creation  18 Dec 06
 * @version   $Revision$ $Date: 5/19/2005 6:11:00 PM$
 * @since     Baja 1.0
 */
public class BFlexFacetsFE
  extends BFacetsFE
{ 

////////////////////////////////////////////////////////////////
// BObject 
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BFlexFacetsFE.class);

////////////////////////////////////////////////////////////////
// Cosntructor
////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////
// BWbEditor
////////////////////////////////////////////////////////////////
  protected void doLoadValue(BObject facetsValue, Context cx)
  {
    facets = (BFacets)facetsValue;
    super.doLoadValue(facetsValue, cx);
  }
  
  

////////////////////////////////////////////////////////////////
// Events
////////////////////////////////////////////////////////////////

  public void doEditPressed()
  {
    try
    { 
      BFacets temp = BFlexFacetsEditor.open(this, facets, isReadonly());
      if (temp != null)
      {
        loadValue(temp, getCurrentContext());
        setModified();
      }
    }
    catch (Exception e) { BDialog.error(this, "Error", "Error", e); }
  }
  

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  private BFacets facets;
}
