/*
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.flexSerial.ui;

import java.io.*;
import java.nio.charset.StandardCharsets;

import javax.baja.sys.*;
import javax.baja.ui.*;
import javax.baja.ui.util.*;
import javax.baja.workbench.*;
import javax.baja.workbench.fieldeditor.*;

import javax.baja.nre.util.*;
import javax.baja.util.*;

/**
 * BFlexBlobFE provides a default implementation of
 * BWbFieldEditor for BBlob. Displays byte array as a hex string
 * in a BTextField.
 *
 * @author    Andy Saunders
 * @creation  20 Sept 2005
 * @version   $Revision: 1$ $Date: 3/28/2005 1:40:35 PM$
 * @since     Baja 1.0
 */
public class BFlexBlobFE
  extends BWbFieldEditor
{

  /*-

  class BFlexBlobFE
  {

    properties
    {
      content: BWidget
        default {[ new BTextField("", 40) ]}
    }

  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.flexSerial.ui.BFlexBlobFE(4222659425)1.0$ @*/
/* Generated Thu Feb 14 10:05:07 GMT-05:00 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "content"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>content</code> property.
   * @see com.tridium.flexSerial.ui.BFlexBlobFE#getContent
   * @see com.tridium.flexSerial.ui.BFlexBlobFE#setContent
   */
  public static final Property content = newProperty(0, new BTextField("", 40),null);

  /**
   * Get the <code>content</code> property.
   * @see com.tridium.flexSerial.ui.BFlexBlobFE#content
   */
  public BWidget getContent() { return (BWidget)get(content); }

  /**
   * Set the <code>content</code> property.
   * @see com.tridium.flexSerial.ui.BFlexBlobFE#content
   */
  public void setContent(BWidget v) { set(content,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BFlexBlobFE.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BFlexBlobFE()
  {
    BTextField field = (BTextField)getContent();
    linkTo("linkA", field, BTextField.textModified, setModified);
    linkTo("linkB", field, BTextField.actionPerformed, actionPerformed);
  }

  protected void doSetReadonly(boolean readonly)
  {
    //((BTextField)getContent()).setEditable(!readonly);
    ((BTextField)getContent()).setEditable(false);
  }

  protected void doLoadValue(BObject value, Context context)
  {
    try
    {
      //System.out.println("BBlobFE facets = " + context.getFacets());
      if( ! context.getFacets().getb("showAscii", false))
        ((BTextField)getContent()).setText(ByteArrayUtil.toHexString(((BBlob)value).copyBytes()));
      else
        ((BTextField)getContent()).setText(new String(((BBlob)value).copyBytes(), StandardCharsets.US_ASCII) );
    }
    catch(Exception e)
    {
      // this shouldn't ever happen
      throw new BajaRuntimeException(e);
    }
  }

  protected BObject doSaveValue(BObject value, Context cx)
    throws Exception
  {
    String str = ((BTextField)getContent()).getText();
    try
    {
      return value.asSimple().decodeFromString(str);
    }
    catch(IOException e)
    {
      // msg -> Cannot parse "{0}" into a {1}.
      Object[] args = { str, value.getType() };
      String msg = UiLexicon.bajaui().getText("defaultSimplePlugin.error", args);
      throw new CannotSaveException(msg);
    }
  }

}
