/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.flexSerial.messages;

import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import com.tridium.flexSerial.enums.BDataTypeEnum;

/**
 * BFlexMarkerElement defines a primitive message element.
 * <P>The purpose of the FlexMessageElement is to completely define a primitive element
 * of a message.  It contain enough information to serialize this element value to and
 * from a native byte array.  The FlexSerial driver provides a special view and editor
 * that can be used to create FlexMessageElements.</P>
 *
 * @author    Andy Saunders
 * @creation  14 Sept 2005
 * @version   $Revision: 35$ $Date: 3/31/2004 9:03:52 AM$
 * @since     Baja 1.0
 */
public class BFlexMarkerElement
  extends BFlexMessageElement
  implements BIFlexMessageElement
{

  /*-

  class BFlexMarkerElement
  {
    properties
    {
      size: int
        flags { readonly }
        -- This is the byte size of this message element.  It is automatically set
        -- based on the dataType selected.
        default {[ 0 ]}

      dataType: BDataTypeEnum
        flags { readonly }
        -- Specifies that this is a byte data type.
        default {[ BDataTypeEnum.Marker ]}

      value: BValue
        -- This is the value of this message element and is dependent on the dataType
        -- specified.  This value can be a constant or can be a "indirect" value from
        -- the object defined in the source property.
        default {[ BString.make("") ]}

    }

  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.flexSerial.messages.BFlexMarkerElement(1756456241)1.0$ @*/
/* Generated Thu Feb 14 10:05:07 GMT-05:00 2008 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "size"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>size</code> property.
   * @see com.tridium.flexSerial.messages.BFlexMarkerElement#getSize
   * @see com.tridium.flexSerial.messages.BFlexMarkerElement#setSize
   */
  public static final Property size = newProperty(Flags.READONLY, 0,null);
  
  /**
   * Get the <code>size</code> property.
   * @see com.tridium.flexSerial.messages.BFlexMarkerElement#size
   */
  public int getSize() { return getInt(size); }
  
  /**
   * Set the <code>size</code> property.
   * @see com.tridium.flexSerial.messages.BFlexMarkerElement#size
   */
  public void setSize(int v) { setInt(size,v,null); }

////////////////////////////////////////////////////////////////
// Property "dataType"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>dataType</code> property.
   * @see com.tridium.flexSerial.messages.BFlexMarkerElement#getDataType
   * @see com.tridium.flexSerial.messages.BFlexMarkerElement#setDataType
   */
  public static final Property dataType = newProperty(Flags.READONLY, BDataTypeEnum.Marker,null);
  
  /**
   * Get the <code>dataType</code> property.
   * @see com.tridium.flexSerial.messages.BFlexMarkerElement#dataType
   */
  public BDataTypeEnum getDataType() { return (BDataTypeEnum)get(dataType); }
  
  /**
   * Set the <code>dataType</code> property.
   * @see com.tridium.flexSerial.messages.BFlexMarkerElement#dataType
   */
  public void setDataType(BDataTypeEnum v) { set(dataType,v,null); }

////////////////////////////////////////////////////////////////
// Property "value"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>value</code> property.
   * This is the value of this message element and is dependent
   * on the dataType specified.  This value can be a constant
   * or can be a "indirect" value from the object defined
   * in the source property.
   * @see com.tridium.flexSerial.messages.BFlexMarkerElement#getValue
   * @see com.tridium.flexSerial.messages.BFlexMarkerElement#setValue
   */
  public static final Property value = newProperty(0, BString.make(""),null);
  
  /**
   * Get the <code>value</code> property.
   * @see com.tridium.flexSerial.messages.BFlexMarkerElement#value
   */
  public BValue getValue() { return get(value); }
  
  /**
   * Set the <code>value</code> property.
   * @see com.tridium.flexSerial.messages.BFlexMarkerElement#value
   */
  public void setValue(BValue v) { set(value,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BFlexMarkerElement.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////

}
