/**
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.flexSerial.enums;

import javax.baja.sys.*;

/**
 * The BDataTypeEnum class provides enumeration of data type selection for messageElement data.
 * 
 *
 * @author    Andy Saunders        
 * @creation  07 July 2004
 * @version   $Revision: 1$ $Date: 04/05/02 12:47:14 PM$  
 * @since     Niagara 3.0 andi 1.0     
 */
public final class BDataTypeEnum
  extends BFrozenEnum  
{
  /*-
  enum BDataTypeEnum
  {
    range
    {
      Byte,
        -- Defines a single byte (8-bits) of data.    
      Word,
        -- Defines two bytes (16-bits) of data.    
      Integer,
        -- Defines 4 bytes (32-bits) of data.    
      Float,
        -- Defines 4 bytes IEEE floating point number.    
      String,
        -- Defines String value.    
      Marker,
        -- A special named placeholder that consumes no space in the message
        -- but defines an offset into the message. "cksumStart" is a special named marker
        -- that defines the message offset at which cksum calculations start. 
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.flexSerial.enums.BDataTypeEnum(868876969)1.0$ @*/
/* Generated Wed Oct 12 14:31:41 EDT 2005 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */
  
  /** Ordinal value for Byte. */
  public static final int BYTE = 0;
  /** Ordinal value for Word. */
  public static final int WORD = 1;
  /** Ordinal value for Integer. */
  public static final int INTEGER = 2;
  /** Ordinal value for Float. */
  public static final int FLOAT = 3;
  /** Ordinal value for String. */
  public static final int STRING = 4;
  /** Ordinal value for Marker. */
  public static final int MARKER = 5;
  
  /** BDataTypeEnum constant for Byte. */
  public static final BDataTypeEnum Byte = new BDataTypeEnum(BYTE);
  /** BDataTypeEnum constant for Word. */
  public static final BDataTypeEnum Word = new BDataTypeEnum(WORD);
  /** BDataTypeEnum constant for Integer. */
  public static final BDataTypeEnum Integer = new BDataTypeEnum(INTEGER);
  /** BDataTypeEnum constant for Float. */
  public static final BDataTypeEnum Float = new BDataTypeEnum(FLOAT);
  /** BDataTypeEnum constant for String. */
  public static final BDataTypeEnum String = new BDataTypeEnum(STRING);
  /** BDataTypeEnum constant for Marker. */
  public static final BDataTypeEnum Marker = new BDataTypeEnum(MARKER);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDataTypeEnum.class);
  
  /** Factory method with ordinal. */
  public static BDataTypeEnum make(int ordinal)
  {
    return (BDataTypeEnum)Byte.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BDataTypeEnum make(String tag)
  {
    return (BDataTypeEnum)Byte.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BDataTypeEnum(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/



}
