/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.flexSerial.comm;

import java.io.*;
import javax.baja.sys.*;
import javax.baja.io.*;
import javax.baja.status.*;
import javax.baja.nre.util.*;
import javax.baja.util.*;

import com.tridium.flexSerial.*;

/**
 * BMessageDef defines the message framing bytes.
 *   Defines both start bytes and end bytes.
 *
 * @author    Andy Saunders
 * @creation  22 April 2004
 * @version   $Revision: 35$ $Date: 3/31/2004 9:03:52 AM$
 * @since     Baja 1.0
 */
public class BMessageDef
  extends BComponent
{

  /*-

  class BMessageDef
  {
    properties
    {
      frameStart: String
        -- Defines bytes all messages must start with.
        --    Maximum of 10 bytes in length.
        -- Control characters may be entered by using the '\' character.
        --    '\\' = '\',
        --    '\r' =  x0d,
        --    '\n' =  x0a,
        --    '\t' =  x09,
        --    '\f' =  x0c,
        --    '\a' =  x07,
        --    '\e' =  x1b, or
        --    '\xhh' for any hh hex value.
        default {[ "" ]}

      frameEnd: String
        -- Defines bytes all messages must end with.
        -- Control characters may be entered by using the '\' character.
        --    '\\' = '\',
        --    '\r' =  x0d,
        --    '\n' =  x0a,
        --    '\t' =  x09,
        --    '\f' =  x0c,
        --    '\a' =  x07,
        --    '\e' =  x1b, or
        --    '\xhh' for any hh hex value.
        default {[ "" ]}

      startBytes: String
        -- Displays the decoded frameStart bytes.
        flags { operator, readonly, transient, summary }
        default {[ "" ]}

      endBytes: String
        -- Displays the decoded frameEnd bytes.
        flags { operator, readonly, transient, summary }
        default {[ "" ]}
    }

  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.flexSerial.comm.BMessageDef(491538807)1.0$ @*/
/* Generated Tue May 18 11:18:21 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "frameStart"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>frameStart</code> property.
   * Defines bytes all messages must start with.    Maximum
   * of 10 bytes in length. Control characters may be entered
   * by using the '\' character.    '\\' = '\',    '\r'
   * =  x0d,    '\n' =  x0a,    '\t' =  x09,    '\f' =  x0c,    '\a' =  x07,    '\e' =  x1b, or    '\xhh' for any hh hex value.
   * @see com.tridium.flexSerial.comm.BMessageDef#getFrameStart
   * @see com.tridium.flexSerial.comm.BMessageDef#setFrameStart
   */
  public static final Property frameStart = newProperty(0, "",null);

  /**
   * Get the <code>frameStart</code> property.
   * @see com.tridium.flexSerial.comm.BMessageDef#frameStart
   */
  public String getFrameStart() { return getString(frameStart); }

  /**
   * Set the <code>frameStart</code> property.
   * @see com.tridium.flexSerial.comm.BMessageDef#frameStart
   */
  public void setFrameStart(String v) { setString(frameStart,v,null); }

////////////////////////////////////////////////////////////////
// Property "frameEnd"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>frameEnd</code> property.
   * Defines bytes all messages must end with. Control characters may be entered by using the '\' character.    '\\' = '\',    '\r' =  x0d,    '\n' =  x0a,    '\t' =  x09,    '\f' =  x0c,    '\a' =  x07,    '\e' =  x1b, or    '\xhh' for any hh hex value.
   * @see com.tridium.flexSerial.comm.BMessageDef#getFrameEnd
   * @see com.tridium.flexSerial.comm.BMessageDef#setFrameEnd
   */
  public static final Property frameEnd = newProperty(0, "",null);

  /**
   * Get the <code>frameEnd</code> property.
   * @see com.tridium.flexSerial.comm.BMessageDef#frameEnd
   */
  public String getFrameEnd() { return getString(frameEnd); }

  /**
   * Set the <code>frameEnd</code> property.
   * @see com.tridium.flexSerial.comm.BMessageDef#frameEnd
   */
  public void setFrameEnd(String v) { setString(frameEnd,v,null); }

////////////////////////////////////////////////////////////////
// Property "startBytes"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>startBytes</code> property.
   * Displays the decoded frameStart bytes.
   * @see com.tridium.flexSerial.comm.BMessageDef#getStartBytes
   * @see com.tridium.flexSerial.comm.BMessageDef#setStartBytes
   */
  public static final Property startBytes = newProperty(Flags.OPERATOR|Flags.READONLY|Flags.TRANSIENT|Flags.SUMMARY, "",null);

  /**
   * Get the <code>startBytes</code> property.
   * @see com.tridium.flexSerial.comm.BMessageDef#startBytes
   */
  public String getStartBytes() { return getString(startBytes); }

  /**
   * Set the <code>startBytes</code> property.
   * @see com.tridium.flexSerial.comm.BMessageDef#startBytes
   */
  public void setStartBytes(String v) { setString(startBytes,v,null); }

////////////////////////////////////////////////////////////////
// Property "endBytes"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>endBytes</code> property.
   * Displays the decoded frameEnd bytes.
   * @see com.tridium.flexSerial.comm.BMessageDef#getEndBytes
   * @see com.tridium.flexSerial.comm.BMessageDef#setEndBytes
   */
  public static final Property endBytes = newProperty(Flags.OPERATOR|Flags.READONLY|Flags.TRANSIENT|Flags.SUMMARY, "",null);

  /**
   * Get the <code>endBytes</code> property.
   * @see com.tridium.flexSerial.comm.BMessageDef#endBytes
   */
  public String getEndBytes() { return getString(endBytes); }

  /**
   * Set the <code>endBytes</code> property.
   * @see com.tridium.flexSerial.comm.BMessageDef#endBytes
   */
  public void setEndBytes(String v) { setString(endBytes,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BMessageDef.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////

  public void started()
  {
    init();
  }

  public void changed(Property property, Context context)
  {
    if(isRunning())
    {
      if(property.equals(frameStart) || property.equals(frameEnd) )
      {
        init();
      }
    }
  }

  void init()
  {
    startByteArray = getFrameBytes(getFrameStart());
    endByteArray   = getFrameBytes(getFrameEnd());
    setStartBytes(ByteArrayUtil.toHexString(startByteArray));
    setEndBytes(ByteArrayUtil.toHexString(endByteArray));
    if(getParent() instanceof BFlexSerialNetwork)
      ((BFlexSerialNetwork)getParent()).messageDefChanged();
  }

  public byte[] getFrameStartBytes() { return startByteArray; }
  public byte[] getFrameEndBytes()   { return endByteArray  ; }

  public static byte[] getFrameBytes(String string)
  {
    ByteArrayOutputStream out = new ByteArrayOutputStream();
    int state = 0;
    int outValue = 0;
    for(int i = 0; i < string.length(); i++)
    {
      int inValue = string.charAt(i) & 0x0ff;
      switch(state)
      {
      case 0:
        if(inValue == '\\') {state = 1; break;}
        out.write( (byte)inValue); break;

      case 1:
        switch(inValue)
        {
        case '\\': out.write('\\'); state = 0; break;
        case 'r':  out.write(0x0d); state = 0;  break;
        case 'n':  out.write(0x0a); state = 0;  break;
        case 't':  out.write(0x09); state = 0;  break;
        case 'f':  out.write(0x0c); state = 0;  break;
        case 'a':  out.write(0x07); state = 0;  break;
        case 'e':  out.write(0x1b); state = 0;  break;
        case 'x': state = 2; break;
        }
        break;

      case 2:
        outValue = Character.digit((char)inValue, 16) & 0x0f;
        state = 3;
        break;
      case 3:
        outValue = outValue << 4 | (Character.digit((char)inValue, 16) & 0x0f);
        out.write( outValue );
        state = 0;
        break;
      }
    }
    return out.toByteArray();
  }

////////////////////////////////////////////////////////////////
// attributes
////////////////////////////////////////////////////////////////

  byte[] startByteArray = new byte[0];
  byte[] endByteArray = new byte[0];

}
