/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.flexSerial;

import java.io.*;
import javax.baja.sys.*;
import javax.baja.io.*;
import javax.baja.status.*;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.control.*;

import com.tridium.flexSerial.*;
import com.tridium.flexSerial.messages.*;

/**
 * BSerialSend will send a request and expose the response
 *
 * @author    Andy Saunders
 * @creation  16 April 2004
 * @version   $Revision: 35$ $Date: 3/31/2004 9:03:52 AM$
 * @since     Baja 1.0
 */
public class BSerialSend
  extends BComponent
  implements BIStatus
{ 

  /*-
  
  class BSerialSend
  {
    properties
    {
      in: BStatusString
        -- The intput is a string.
        flags { operator, summary }
        default {[ new BStatusString("") ]}
 
      addFrameStart: boolean
        -- If true start framing will automatically be added
        default {[ true ]}
         
      addFrameEnd: boolean
        -- If true end framing will automatically be added
        default {[ true ]}
         
        
      status: BStatus
        flags { transient, readonly, summary }
        default {[ BStatus.ok ]}

        
    }
    
    actions
    {
      send()
        flags{ async }
    }

  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.flexSerial.BSerialSend(2173033307)1.0$ @*/
/* Generated Thu Jan 04 11:28:12 EST 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "in"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>in</code> property.
   * The intput is a string.
   * @see com.tridium.flexSerial.BSerialSend#getIn
   * @see com.tridium.flexSerial.BSerialSend#setIn
   */
  public static final Property in = newProperty(Flags.OPERATOR|Flags.SUMMARY, new BStatusString(""),null);
  
  /**
   * Get the <code>in</code> property.
   * @see com.tridium.flexSerial.BSerialSend#in
   */
  public BStatusString getIn() { return (BStatusString)get(in); }
  
  /**
   * Set the <code>in</code> property.
   * @see com.tridium.flexSerial.BSerialSend#in
   */
  public void setIn(BStatusString v) { set(in,v,null); }

////////////////////////////////////////////////////////////////
// Property "addFrameStart"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addFrameStart</code> property.
   * If true start framing will automatically be added
   * @see com.tridium.flexSerial.BSerialSend#getAddFrameStart
   * @see com.tridium.flexSerial.BSerialSend#setAddFrameStart
   */
  public static final Property addFrameStart = newProperty(0, true,null);
  
  /**
   * Get the <code>addFrameStart</code> property.
   * @see com.tridium.flexSerial.BSerialSend#addFrameStart
   */
  public boolean getAddFrameStart() { return getBoolean(addFrameStart); }
  
  /**
   * Set the <code>addFrameStart</code> property.
   * @see com.tridium.flexSerial.BSerialSend#addFrameStart
   */
  public void setAddFrameStart(boolean v) { setBoolean(addFrameStart,v,null); }

////////////////////////////////////////////////////////////////
// Property "addFrameEnd"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>addFrameEnd</code> property.
   * If true end framing will automatically be added
   * @see com.tridium.flexSerial.BSerialSend#getAddFrameEnd
   * @see com.tridium.flexSerial.BSerialSend#setAddFrameEnd
   */
  public static final Property addFrameEnd = newProperty(0, true,null);
  
  /**
   * Get the <code>addFrameEnd</code> property.
   * @see com.tridium.flexSerial.BSerialSend#addFrameEnd
   */
  public boolean getAddFrameEnd() { return getBoolean(addFrameEnd); }
  
  /**
   * Set the <code>addFrameEnd</code> property.
   * @see com.tridium.flexSerial.BSerialSend#addFrameEnd
   */
  public void setAddFrameEnd(boolean v) { setBoolean(addFrameEnd,v,null); }

////////////////////////////////////////////////////////////////
// Property "status"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>status</code> property.
   * @see com.tridium.flexSerial.BSerialSend#getStatus
   * @see com.tridium.flexSerial.BSerialSend#setStatus
   */
  public static final Property status = newProperty(Flags.TRANSIENT|Flags.READONLY|Flags.SUMMARY, BStatus.ok,null);
  
  /**
   * Get the <code>status</code> property.
   * @see com.tridium.flexSerial.BSerialSend#status
   */
  public BStatus getStatus() { return (BStatus)get(status); }
  
  /**
   * Set the <code>status</code> property.
   * @see com.tridium.flexSerial.BSerialSend#status
   */
  public void setStatus(BStatus v) { set(status,v,null); }

////////////////////////////////////////////////////////////////
// Action "send"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>send</code> action.
   * @see com.tridium.flexSerial.BSerialSend#send()
   */
  public static final Action send = newAction(0,null);
  
  /**
   * Invoke the <code>send</code> action.
   * @see com.tridium.flexSerial.BSerialSend#send
   */
  public void send() { invoke(send,null,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BSerialSend.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// ControlPoint
////////////////////////////////////////////////////////////////  

  public void started()
  {
    network = getNetwork();
    setStatus(BStatus.makeFault(getStatus(), (network == null)));
  }

  public void changed(Property property, Context context) 
  {
    if(isRunning())
    {
      if(property == in) postSend();
    }
  }

  /**
   * Callback to post an async action.  Subclasses should call super.
   */
  public IFuture post(Action action, BValue arg, Context cx)
  {
    if (action.equals(send)) return postSend();
    return super.post(action, arg, cx);
  }


  protected IFuture postSend()
  {
	  if(this.isRunning())
	  	return getNetwork().postAsync(new Invocation(this, send, null, null));
	  return null;
  }

  
  public void doSend()
  {
    if(getNetwork() == null)
      return;
    String frameStart = new String(network.getMessageBlocks().getFrameStart().getByteArray());
    String frameEnd = new String(network.getMessageBlocks().getFrameEnd().getByteArray());
    String reqData = getIn().getValue();
    if(getAddFrameStart())
    {
      reqData = frameStart + reqData;
    }
    if(getAddFrameEnd())
    {
      reqData = reqData + frameEnd;
    }
    SerialMessage req = new SerialMessage(reqData);
    req.setResponseExpected(false);
    network.sendSync(req);
  }

  BFlexSerialNetwork getNetwork()
  {
    if(network != null) return network;
    BComplex parent = this.getParent();
    while(parent != null)
    {
      if(parent instanceof BFlexSerialNetwork)
      {
        network = (BFlexSerialNetwork)parent;
        return network;
      }
      parent = parent.getParent();
    }
    return null;
  }

////////////////////////////////////////////////////////////////
// Presentation
////////////////////////////////////////////////////////////////  

  /**
   * Get the icon.
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("control/util/switch.png");
  */

////////////////////////////////////////////////////////////////
// attributes
////////////////////////////////////////////////////////////////  
  BFlexSerialNetwork network;

}
