/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.file.types.video;

import javax.baja.file.BIFileStore;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BAviFile stores AVI Videos.
 *
 * @author    Tom Duffy       
 * @creation  13 Jun 2013
 */
public class BAviFile
  extends BVideoFile 
{
  ////////////////////////////////////////////////////////////////
  //Constructor
  ////////////////////////////////////////////////////////////////
  
  /**
  * Construct a file with the specified store.
  */
  public BAviFile(BIFileStore store)
  {
    super(store);
  }
  
  /**
   * Construct (must call setStore()).
   */
  public BAviFile()
  {  
  }
  
  ////////////////////////////////////////////////////////////////
  //Overrides
  ////////////////////////////////////////////////////////////////
  
  /**
  * Return {@code "video/avi"}.
  */
  @Override
  public String getMimeType()
  {
    return "video/avi";
  }

  ////////////////////////////////////////////////////////////////
  //Type
  ////////////////////////////////////////////////////////////////

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BAviFile.class);
}
