/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.file.types.text;

import javax.baja.file.BIFileStore;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * A JNLP file used for Java WebStart Applications.
 *
 * @author Gareth Johnson on 24/03/2015
 * @since Niagara 4.0
 */
@SuppressWarnings("unused")
public final class BJnlpFile extends BXmlFile
{
  public BJnlpFile(BIFileStore store)
  {
    super(store);
  }

  public BJnlpFile() {}

  @Override
  public String getMimeType()
  {
    return mimeType;
  }

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BJnlpFile.class);

  public static final String mimeType = "application/x-java-jnlp-file";
}
