/*
 * Copyright 2006 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.file.types.image;

import javax.baja.file.BIFileStore;
import javax.baja.file.types.text.BIXmlFile;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BSvgFile stores an SVG image.
 *
 * @author    Andy Frank       
 * @creation  09 Jan 06
 * @version   $Revision: 1$ $Date: 1/9/06 4:27:44 PM EST$
 * @since     Baja 1.0
 */
public class BSvgFile
  extends BImageFile
  implements BIXmlFile
{ 

////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  /**
   * Construct a file with the specified store.
   */
  public BSvgFile(BIFileStore store)
  {
    super(store);
  }

  /**
   * Construct (must call setStore()).
   */
  public BSvgFile()
  {  
  }

////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

  /**
   * Return {@code "image/svg+xml"}.
   */
  @Override
  public String getMimeType()
  {
    return "image/svg+xml";
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////  

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BSvgFile.class);

}
