/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.file.types.audio;

import javax.baja.file.BIFileStore;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BM4aFile stores M4A audio.
 *
 * @author    Tom Duffy       
 * @creation  13 Jun 2013
 */
public class BM4aFile
  extends BAudioFile 
{
  ////////////////////////////////////////////////////////////////
  //Constructor
  ////////////////////////////////////////////////////////////////
  
  /**
  * Construct a file with the specified store.
  */
  public BM4aFile(BIFileStore store)
  {
    super(store);
  }
  
  /**
   * Construct (must call setStore()).
   */
  public BM4aFile()
  {  
  }
  
  ////////////////////////////////////////////////////////////////
  //Overrides
  ////////////////////////////////////////////////////////////////
  
  /**
  * Return {@code "audio/mp4"}.
  */
  @Override
  public String getMimeType()
  {
    return "audio/mp4";
  }

  ////////////////////////////////////////////////////////////////
  //Type
  ////////////////////////////////////////////////////////////////

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BM4aFile.class);
}
