/*
 * Copyright 2003 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.file.types.bog;

import javax.baja.naming.BOrdScheme;
import javax.baja.naming.InvalidOrdBaseException;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BBogScheme is the portal from BogFile to BogSpace.
 *
 * @author    Brian Frank
 * @creation  4 Jan 03
 * @version   $Revision: 2$ $Date: 8/28/07 5:41:54 PM EDT$
 * @since     Baja 1.0
 */
public class BBogScheme
  extends BOrdScheme
{

////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  /**
   * Private constructor.
   */
  private BBogScheme()
  {
    super("bog");
  }

////////////////////////////////////////////////////////////////
// BOrdScheme
////////////////////////////////////////////////////////////////

  /**
   * Return base.
   */
  @Override
  public OrdTarget resolve(OrdTarget base, OrdQuery query)
    throws SyntaxException, UnresolvedException
  {
    if (!(base.get() instanceof BBogFile))
    {
      throw new InvalidOrdBaseException("Must be BogFile: " + base.get().getType());
    }

    BBogFile bogFile = (BBogFile)base.get();
    BBogSpace space = (BBogSpace)bogFile.open();
    return new OrdTarget(base, space);
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public static final BBogScheme INSTANCE = new BBogScheme();

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBogScheme.class);

}

