/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.driver.util;

import javax.baja.sys.BInterface;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BIPollable is the interface implemented by components
 * used with the BPollManager to build a poll scheme.
 *
 * @author    Brian Frank
 * @creation  21 Jan 02
 * @version   $Revision: 2$ $Date: 12/20/02 2:32:33 PM EST$
 * @since     Baja 1.0
 */
public interface BIPollable
  extends BInterface
{

  /**
   * Get the component's configured poll frequency.
   */
  BPollFrequency getPollFrequency();

  Type TYPE = Sys.loadType(BIPollable.class);
}

