/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.driver.point;

import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BTuningPolicy stores configuration to determine how 
 * and when proxy points are read and written.
 *
 * @author    Brian Frank       
 * @creation  23 Jun 04
 * @version   $Revision: 9$ $Date: 3/29/06 4:24:56 PM EST$
 * @since     Baja 1.0
 */
public class BTuningPolicy
  extends BComponent
{ 
  /*-
  
  class BTuningPolicy
  {  
    properties 
    {                   
      minWriteTime: BRelTime
        -- Min amount of time between writes.  This value
        -- provides the ability to throttle rapidly changing
        -- data so that only the last value is written.  If
        -- the value is zero then this feature is disabled.
        default {[ BRelTime.make(0) ]}
        slotfacets {[ BFacets.make(BFacets.MIN,BRelTime.make(0)) ]}
      maxWriteTime: BRelTime                           
        -- Max amount of time to allow before a rewrite is
        -- issued if nothing else has trigged a write.  If
        -- the value is zero then this feature is disabled.
        default {[ BRelTime.make(0) ]}
        slotfacets {[ BFacets.make(BFacets.MIN,BRelTime.make(0)) ]}
      writeOnStart: boolean
        -- If true then a write is issued when the station
        -- reaches steady state.
        default {[ true ]}
      writeOnUp: boolean       
        -- If true then a write is issued when the containing
        -- device transitions its status from down to up.
        default {[ true ]}
      writeOnEnabled: boolean
        -- If true then a write is issued when the point transitions 
        -- its status from disabled to enabled.
        default {[ true ]}    
      staleTime: BRelTime            
        -- This property is used to configure when point data
        -- becomes stale.  If set to non-zero then points become
        -- stale if the configured time elapses without a successful
        -- read (indicated by readOk).  If set to zero then the
        -- stale timer is disabled, and points are set to stale
        -- immediately when unsubscribed.
        default {[ BRelTime.make(0) ]}
        slotfacets {[ BFacets.make(BFacets.MIN,BRelTime.make(0)) ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.driver.point.BTuningPolicy(1873405996)1.0$ @*/
/* Generated Wed Mar 29 14:28:02 EST 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "minWriteTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>minWriteTime</code> property.
   * Min amount of time between writes.  This value provides
   * the ability to throttle rapidly changing data so that
   * only the last value is written.  If the value is zero
   * then this feature is disabled.
   * @see javax.baja.driver.point.BTuningPolicy#getMinWriteTime
   * @see javax.baja.driver.point.BTuningPolicy#setMinWriteTime
   */
  public static final Property minWriteTime = newProperty(0, BRelTime.make(0),BFacets.make(BFacets.MIN,BRelTime.make(0)) );
  
  /**
   * Get the <code>minWriteTime</code> property.
   * @see javax.baja.driver.point.BTuningPolicy#minWriteTime
   */
  public BRelTime getMinWriteTime() { return (BRelTime)get(minWriteTime); }
  
  /**
   * Set the <code>minWriteTime</code> property.
   * @see javax.baja.driver.point.BTuningPolicy#minWriteTime
   */
  public void setMinWriteTime(BRelTime v) { set(minWriteTime,v,null); }

////////////////////////////////////////////////////////////////
// Property "maxWriteTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>maxWriteTime</code> property.
   * Max amount of time to allow before a rewrite is issued
   * if nothing else has trigged a write.  If the value
   * is zero then this feature is disabled.
   * @see javax.baja.driver.point.BTuningPolicy#getMaxWriteTime
   * @see javax.baja.driver.point.BTuningPolicy#setMaxWriteTime
   */
  public static final Property maxWriteTime = newProperty(0, BRelTime.make(0),BFacets.make(BFacets.MIN,BRelTime.make(0)) );
  
  /**
   * Get the <code>maxWriteTime</code> property.
   * @see javax.baja.driver.point.BTuningPolicy#maxWriteTime
   */
  public BRelTime getMaxWriteTime() { return (BRelTime)get(maxWriteTime); }
  
  /**
   * Set the <code>maxWriteTime</code> property.
   * @see javax.baja.driver.point.BTuningPolicy#maxWriteTime
   */
  public void setMaxWriteTime(BRelTime v) { set(maxWriteTime,v,null); }

////////////////////////////////////////////////////////////////
// Property "writeOnStart"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>writeOnStart</code> property.
   * If true then a write is issued when the station reaches
   * steady state.
   * @see javax.baja.driver.point.BTuningPolicy#getWriteOnStart
   * @see javax.baja.driver.point.BTuningPolicy#setWriteOnStart
   */
  public static final Property writeOnStart = newProperty(0, true,null);
  
  /**
   * Get the <code>writeOnStart</code> property.
   * @see javax.baja.driver.point.BTuningPolicy#writeOnStart
   */
  public boolean getWriteOnStart() { return getBoolean(writeOnStart); }
  
  /**
   * Set the <code>writeOnStart</code> property.
   * @see javax.baja.driver.point.BTuningPolicy#writeOnStart
   */
  public void setWriteOnStart(boolean v) { setBoolean(writeOnStart,v,null); }

////////////////////////////////////////////////////////////////
// Property "writeOnUp"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>writeOnUp</code> property.
   * If true then a write is issued when the containing
   * device transitions its status from down to up.
   * @see javax.baja.driver.point.BTuningPolicy#getWriteOnUp
   * @see javax.baja.driver.point.BTuningPolicy#setWriteOnUp
   */
  public static final Property writeOnUp = newProperty(0, true,null);
  
  /**
   * Get the <code>writeOnUp</code> property.
   * @see javax.baja.driver.point.BTuningPolicy#writeOnUp
   */
  public boolean getWriteOnUp() { return getBoolean(writeOnUp); }
  
  /**
   * Set the <code>writeOnUp</code> property.
   * @see javax.baja.driver.point.BTuningPolicy#writeOnUp
   */
  public void setWriteOnUp(boolean v) { setBoolean(writeOnUp,v,null); }

////////////////////////////////////////////////////////////////
// Property "writeOnEnabled"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>writeOnEnabled</code> property.
   * If true then a write is issued when the point transitions
   * its status from disabled to enabled.
   * @see javax.baja.driver.point.BTuningPolicy#getWriteOnEnabled
   * @see javax.baja.driver.point.BTuningPolicy#setWriteOnEnabled
   */
  public static final Property writeOnEnabled = newProperty(0, true,null);
  
  /**
   * Get the <code>writeOnEnabled</code> property.
   * @see javax.baja.driver.point.BTuningPolicy#writeOnEnabled
   */
  public boolean getWriteOnEnabled() { return getBoolean(writeOnEnabled); }
  
  /**
   * Set the <code>writeOnEnabled</code> property.
   * @see javax.baja.driver.point.BTuningPolicy#writeOnEnabled
   */
  public void setWriteOnEnabled(boolean v) { setBoolean(writeOnEnabled,v,null); }

////////////////////////////////////////////////////////////////
// Property "staleTime"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>staleTime</code> property.
   * This property is used to configure when point data
   * becomes stale.  If set to non-zero then points become
   * stale if the configured time elapses without a successful
   * read (indicated by readOk).  If set to zero then the
   * stale timer is disabled, and points are set to stale
   * immediately when unsubscribed.
   * @see javax.baja.driver.point.BTuningPolicy#getStaleTime
   * @see javax.baja.driver.point.BTuningPolicy#setStaleTime
   */
  public static final Property staleTime = newProperty(0, BRelTime.make(0),BFacets.make(BFacets.MIN,BRelTime.make(0)) );
  
  /**
   * Get the <code>staleTime</code> property.
   * @see javax.baja.driver.point.BTuningPolicy#staleTime
   */
  public BRelTime getStaleTime() { return (BRelTime)get(staleTime); }
  
  /**
   * Set the <code>staleTime</code> property.
   * @see javax.baja.driver.point.BTuningPolicy#staleTime
   */
  public void setStaleTime(BRelTime v) { set(staleTime,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BTuningPolicy.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Constructors
////////////////////////////////////////////////////////////////

  /**
   * Construct a fully specified BTuningPolicy.
   */
  public BTuningPolicy(BRelTime minWriteTime,
                       BRelTime maxWriteTime,
                       boolean  writeOnStart,
                       boolean  writeOnUp,
                       boolean  writeOnEnabled,
                       BRelTime staleTime)
  {
    setMinWriteTime(minWriteTime);    
    setMaxWriteTime(maxWriteTime);    
    setWriteOnStart(writeOnStart);    
    setWriteOnUp(writeOnUp);    
    setWriteOnEnabled(writeOnEnabled);    
    setStaleTime(staleTime);    
  }

  /**
   * No arg constructor.
   */
  public BTuningPolicy() 
  {
  }

////////////////////////////////////////////////////////////////
// Presentation
////////////////////////////////////////////////////////////////

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("wrench.png");  
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  /**
   * This context is passed to ITunable.write() if the write
   * is called because of elapsed maxWriteTime.
   */ 
  public static final Context maxWriteTimeContext = new BasicContext()
  {
    public boolean equals(Object obj) { return this == obj; }
    public int hashCode() { return System.identityHashCode(this); }
    public String toString() { return "TuningPolicy.maxWriteTimeContext"; }
  };

  /**
   * This context is passed to ITunable.write() if the write
   * is called because of the onStart transition.
   */ 
  public static final Context writeOnStartContext = new BasicContext()
  {
    public boolean equals(Object obj) { return this == obj; }
    public int hashCode() { return System.identityHashCode(this); }
    public String toString() { return "TuningPolicy.writeOnStartContext"; }
  };

  /**
   * This context is passed to ITunable.write() if the write
   * is called because of the onUp transition.
   */ 
  public static final Context writeOnUpContext = new BasicContext()
  {
    public boolean equals(Object obj) { return this == obj; }
    public int hashCode() { return System.identityHashCode(this); }
    public String toString() { return "TuningPolicy.writeOnUpContext"; }
  };

  /**
   * This context is passed to ITunable.write() if the write
   * is called because of the onEnabled transition.
   */ 
  public static final Context writeOnEnabledContext = new BasicContext()
  {
    public boolean equals(Object obj) { return this == obj; }
    public int hashCode() { return System.identityHashCode(this); }
    public String toString() { return "TuningPolicy.writeOnEnabledContext"; }
  };
  
  public void started()
    throws Exception
  { 
    // Make update times positive - this is needed because the new MIN facets 
    // will not allow user to edit value to >=0 if originally <0
    setMinWriteTime(getMinWriteTime().abs());
    setMaxWriteTime(getMaxWriteTime().abs());
    setStaleTime(getStaleTime().abs());
    
    super.started();

  }  
  
}
