/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.driver.point;

import java.util.ArrayList;
import javax.baja.agent.AgentList;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.BDeviceExt;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BPointDeviceExt is the base class for mapping devices into
 * standard Baja points.
 *
 * @author    Brian Frank       
 * @creation  17 Oct 01
 * @version   $Revision: 49$ $Date: 7/29/04 6:22:07 PM EDT$
 * @since     Baja 1.0
 */
public abstract class BPointDeviceExt
  extends BDeviceExt
  implements BIPointFolder
{ 

  /*-
  
  class BPointDeviceExt
  {  
    properties 
    {    
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.driver.point.BPointDeviceExt(3138996831)1.0$ @*/
/* Generated Thu Jun 17 09:04:45 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BPointDeviceExt.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

  /**
   * Get the parent device Type.
   */
  public abstract Type getDeviceType();      
  
  /**
   * Get the Type of proxy extensions for this device.
   */
  public abstract Type getProxyExtType();      

  /**
   * Get the Type of point folder for this device.
   */
  public abstract Type getPointFolderType();      

  /**
   * Return this.
   */
  public final BPointDeviceExt getDeviceExt()
  {
    return this;
  }
    
////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////

  /**
   * Get an array containing all the BControlPoints
   * children of this network component.
   */
  public BControlPoint[] getPoints()
  {
    ArrayList<BControlPoint> list = new ArrayList<>();
    getPoints(this, getProxyExtType(), list); 
    return list.toArray(new BControlPoint[list.size()]);
  }
  
  private void getPoints(BComponent comp, Type proxyExtType, ArrayList<BControlPoint> list)
  {           
    // use cursor so we don't taking out any locks                          
    SlotCursor<Property> cursor = comp.loadSlots().getProperties();
    while(cursor.nextComponent())
    {
      BComponent kid = cursor.get().asComponent();
      if (kid instanceof BControlPoint)
      {      
        if (((BControlPoint)kid).getProxyExt().getType().is(proxyExtType))               
          list.add((BControlPoint)kid);
      }
      else
      {
        getPoints(kid, proxyExtType, list);
      }
    }
  }                     
      
////////////////////////////////////////////////////////////////
// Status
////////////////////////////////////////////////////////////////

  /**
   * Update the status of all the points, by calling
   * BProxyExt.updateStatus().
   */
  public void updateStatus()
  {
    BControlPoint[] points = getPoints();
    for (int i=0; i<points.length; i++)
    {
      BAbstractProxyExt ext = points[i].getProxyExt();
      if (ext instanceof BProxyExt)
        ((BProxyExt)ext).updateStatus();
    }
  }
    
////////////////////////////////////////////////////////////////
// Presentation
////////////////////////////////////////////////////////////////

  public AgentList getAgents(Context cx)
  { 
    TypeInfo pointManager = Sys.getRegistry().getType("driver:PointManager");              
    AgentList agents = super.getAgents(cx);
    
    for(int i=0; i<agents.size(); ++i)
      if (agents.get(i).getAgentType().is(pointManager))
        return agents;
        
    agents.add(pointManager.getAgentInfo());
    return agents;
  }

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("navOnly/points.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////


}
