/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.driver.loadable;

import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BUploadParameters is the base class for arguments
 * which are used to tailor the upload process.
 *
 * @author    Brian Frank
 * @creation  13 Jan 01
 * @version   $Revision: 8$ $Date: 3/30/04 8:12:54 PM EST$
 * @since     Baja 1.0
 */
public class BUploadParameters
  extends BLoadableActionParameters
{

  /*-

  class BUploadParameters
  {
    properties
    {
      uploadTransient : boolean
        -- Upload transient properties.
        default {[ true ]}
      uploadPersistent : boolean
        -- Upload persistent properties.
        default {[ true ]}
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.driver.loadable.BUploadParameters(2872644633)1.0$ @*/
/* Generated Tue Mar 30 19:54:26 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "uploadTransient"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>uploadTransient</code> property.
   * Upload transient properties.
   * @see javax.baja.driver.loadable.BUploadParameters#getUploadTransient
   * @see javax.baja.driver.loadable.BUploadParameters#setUploadTransient
   */
  public static final Property uploadTransient = newProperty(0, true,null);
  
  /**
   * Get the <code>uploadTransient</code> property.
   * @see javax.baja.driver.loadable.BUploadParameters#uploadTransient
   */
  public boolean getUploadTransient() { return getBoolean(uploadTransient); }
  
  /**
   * Set the <code>uploadTransient</code> property.
   * @see javax.baja.driver.loadable.BUploadParameters#uploadTransient
   */
  public void setUploadTransient(boolean v) { setBoolean(uploadTransient,v,null); }

////////////////////////////////////////////////////////////////
// Property "uploadPersistent"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>uploadPersistent</code> property.
   * Upload persistent properties.
   * @see javax.baja.driver.loadable.BUploadParameters#getUploadPersistent
   * @see javax.baja.driver.loadable.BUploadParameters#setUploadPersistent
   */
  public static final Property uploadPersistent = newProperty(0, true,null);
  
  /**
   * Get the <code>uploadPersistent</code> property.
   * @see javax.baja.driver.loadable.BUploadParameters#uploadPersistent
   */
  public boolean getUploadPersistent() { return getBoolean(uploadPersistent); }
  
  /**
   * Set the <code>uploadPersistent</code> property.
   * @see javax.baja.driver.loadable.BUploadParameters#uploadPersistent
   */
  public void setUploadPersistent(boolean v) { setBoolean(uploadPersistent,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BUploadParameters.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Default constructor.
   */
  public BUploadParameters() {}

  /**
   * Constructor.
   * @param recursive
   */
  public BUploadParameters(boolean recursive)
  {
    super(recursive);
  }
}
