/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.driver.loadable;

import javax.baja.sys.BStruct;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BLoadableActionParameters is the base class for
 * parameters specifying a lifecycle operation on
 * a BILoadable.
 *
 * @author    Robert Adams
 * @creation  4 Feb 02
 * @version   $Revision: 8$ $Date: 3/30/04 8:12:50 PM EST$
 * @since     Baja 1.0
 */
public abstract class BLoadableActionParameters
  extends BStruct
{

  /*-

  class BLoadableActionParameters
  {
    properties
    {
      recursive: boolean
        -- Should this operation recurse through all the
        -- BILoadable children in the descendent tree.
        default {[ true ]}
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.driver.loadable.BLoadableActionParameters(4233672426)1.0$ @*/
/* Generated Tue Mar 30 19:54:26 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "recursive"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>recursive</code> property.
   * Should this operation recurse through all the BILoadable
   * children in the descendent tree.
   * @see javax.baja.driver.loadable.BLoadableActionParameters#getRecursive
   * @see javax.baja.driver.loadable.BLoadableActionParameters#setRecursive
   */
  public static final Property recursive = newProperty(0, true,null);
  
  /**
   * Get the <code>recursive</code> property.
   * @see javax.baja.driver.loadable.BLoadableActionParameters#recursive
   */
  public boolean getRecursive() { return getBoolean(recursive); }
  
  /**
   * Set the <code>recursive</code> property.
   * @see javax.baja.driver.loadable.BLoadableActionParameters#recursive
   */
  public void setRecursive(boolean v) { setBoolean(recursive,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLoadableActionParameters.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Constructor.
   */
  public BLoadableActionParameters() {}

  /**
   * Full constructor.
   * @param recursive
   */
  public BLoadableActionParameters(boolean recursive)
  {
    setRecursive(recursive);
  }
}
