/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.driver.loadable;

import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/**
 * BLoadable is a BComponent implementation of BILoadable.
 *
 * @author    Robert Adams
 * @creation  4 Feb 02
 * @version   $Revision: 4$ $Date: 9/12/04 1:43:26 PM EDT$
 * @since     Baja 1.0
 */
public abstract class BLoadable
  extends BComponent
  implements BILoadable
{

  /*-

  class BLoadable
  {
    actions
    {
      upload(parameters: BUploadParameters)
        -- Upload reads data from the physical device.
        flags { async }
        default {[ new BUploadParameters() ]}
      download(parameters: BDownloadParameters)
        -- Download writes data to the physical device.
        flags { async }
        default {[ new BDownloadParameters() ]}
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.driver.loadable.BLoadable(2745275755)1.0$ @*/
/* Generated Wed Feb 11 14:55:55 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Action "upload"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>upload</code> action.
   * Upload reads data from the physical device.
   * @see javax.baja.driver.loadable.BLoadable#upload()
   */
  public static final Action upload = newAction(Flags.ASYNC,new BUploadParameters(),null);
  
  /**
   * Invoke the <code>upload</code> action.
   * @see javax.baja.driver.loadable.BLoadable#upload
   */
  public void upload(BUploadParameters parameters) { invoke(upload,parameters,null); }

////////////////////////////////////////////////////////////////
// Action "download"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>download</code> action.
   * Download writes data to the physical device.
   * @see javax.baja.driver.loadable.BLoadable#download()
   */
  public static final Action download = newAction(Flags.ASYNC,new BDownloadParameters(),null);
  
  /**
   * Invoke the <code>download</code> action.
   * @see javax.baja.driver.loadable.BLoadable#download
   */
  public void download(BDownloadParameters parameters) { invoke(download,parameters,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BLoadable.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////

  /**
   * Return BLoadableNetwork ancestor.
   **/
  public BLoadableNetwork getNetwork()
  {
    try
    {                
      return (BLoadableNetwork)getDevice().getNetwork();
    }
    catch(Exception e)
    {
      return null;
    }
  }

  /**
   * Return BLoadableDevice ancestor.
   **/
  public BLoadableDevice getDevice()
  {
    try
    {
      BComplex p  = getParent();
      while (!(p instanceof BLoadableDevice)) p = p.getParent();
      return (BLoadableDevice)p;
    }
    catch(Exception e)
    {
      return null;
    }
  }

  /**
   * Convenience for <code>getNetwork().postAsync(r)</code>.
   */
  public IFuture postAsync(Runnable r)
  {
    return getNetwork().postAsync(r);
  }

////////////////////////////////////////////////////////////////
// BComponent
////////////////////////////////////////////////////////////////

  /** 
   * Return true if parent is a BILoadable
   */
  public boolean isParentLegal(BComponent parent)
  {
    return parent instanceof BILoadable;
  }      
  
////////////////////////////////////////////////////////////////
// Action Post
////////////////////////////////////////////////////////////////
  
  /**
   * Route to postUpload or postDownload.
   */
  public IFuture post(Action action, BValue arg, Context cx)
  {
    if (action.equals(upload)) return postUpload((BUploadParameters)arg, cx);
    if (action.equals(download)) return postDownload((BDownloadParameters)arg, cx);
    return super.post(action, arg, cx);
  }
  
  /**
   * Post an upload Invocation.
   */
  protected IFuture postUpload(BUploadParameters params, Context cx)
  {
    return postAsync(new Invocation(this, upload, params, cx));
  }

  /**
   * Post a download Invocation.
   */
  protected IFuture postDownload(BDownloadParameters params, Context cx)
  {
    return postAsync(new Invocation(this, download, params, cx));
  }  
  
////////////////////////////////////////////////////////////////
// Action Implementation
////////////////////////////////////////////////////////////////

  /**
   * Implementation for processing upload on async thread.
   * Default implementation recurses upload on children.
   */
  public void doUpload(BUploadParameters params, Context cx)
    throws Exception
  {
    if (params.getRecursive())  
      LoadUtil.uploadChildren(this, params, cx);
  }

  /**
   * Implementation for processing download on async thread.
   * Default implementation recurses download on children.
   */
  public void doDownload(BDownloadParameters params, Context cx)
    throws Exception
  {
    if (params.getRecursive())  
      LoadUtil.downloadChildren(this, params, cx);
  }

}
