/*
 * Copyright 2008 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.driver.history;

import javax.baja.driver.util.BIPollable;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BIHistoryPollable is the interface implemented by archive
 * descriptors that can register with the history poll scheduler
 * for polling.
 *
 * @author    Scott Hoye
 * @creation  3 Apr 08
 * @version   $Revision 1$ $Date: 5/15/08 4:15:22 PM EDT$
 * @since     Niagara 3.4
 */
public interface BIHistoryPollable
  extends BIPollable
{

  /**
   * Callback when the poll scheduler says it's time
   * to poll this object.
   */
  public void poll();

  Type TYPE = Sys.loadType(BIHistoryPollable.class);
}

