/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package javax.baja.driver.history;

import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BHistoryExport defines an archive action for transferring
 * one or more histories from the local source to a remote destination.
 *
 * @author    John Sublett
 * @creation  31 Mar 2003
 * @version   $Revision: 9$ $Date: 5/19/09 2:54:57 PM EDT$
 * @since     Baja 1.0
 */
public abstract class BHistoryExport
  extends BArchiveDescriptor
{
  /*-
  
  class BHistoryExport
  {
    properties
    {
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.driver.history.BHistoryExport(3288411247)1.0$ @*/
/* Generated Fri Feb 20 17:08:53 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BHistoryExport.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BHistoryExport()
  {
  }

  /**
   * The specified parent is only legal if it or one
   * of its ancestors is an IArchiveFolder that
   * supports export.
   */
  public boolean isParentLegal(BComponent parent)
  {
    while ((parent != null) && !(parent instanceof BIArchiveFolder))
      parent = (BComponent)parent.getParent();
    
    if (parent == null) return false;
    
    try
    {
      return ((BIArchiveFolder)parent).getExportDescriptorType() != null;
    }
    catch(IllegalStateException e) { return true; }
  }

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.make
    ("module://driver/com/tridium/driver/ui/history/exportHistory.png");
}