/*
 * Copyright 2003, Tridium, Inc. All Rights Reserved.
 */

package javax.baja.driver.history;

import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.util.BDescriptor;
import javax.baja.history.BHistoryId;
import javax.baja.status.BIStatus;
import javax.baja.sys.BComplex;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BArchiveDescriptor describes a history archive.  It includes
 * information about which histories will be archived and
 * when the archive will occur.
 *
 * @author    John Sublett
 * @creation  31 Mar 2003
 * @version   $Revision: 13$ $Date: 9/10/08 11:19:30 AM EDT$
 * @since     Baja 1.0
 */
public abstract class BArchiveDescriptor
  extends BDescriptor
  implements BIStatus
{
  /*-
  
  class BArchiveDescriptor
  {
    properties
    {
      historyId: BHistoryId
        -- The id of the history to be transferred by this descriptor.
        default {[ BHistoryId.NULL ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.driver.history.BArchiveDescriptor(3355103022)1.0$ @*/
/* Generated Fri Mar 18 15:33:42 EST 2005 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "historyId"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>historyId</code> property.
   * The id of the history to be transferred by this descriptor.
   * @see javax.baja.driver.history.BArchiveDescriptor#getHistoryId
   * @see javax.baja.driver.history.BArchiveDescriptor#setHistoryId
   */
  public static final Property historyId = newProperty(0, BHistoryId.NULL,null);
  
  /**
   * Get the <code>historyId</code> property.
   * @see javax.baja.driver.history.BArchiveDescriptor#historyId
   */
  public BHistoryId getHistoryId() { return (BHistoryId)get(historyId); }
  
  /**
   * Set the <code>historyId</code> property.
   * @see javax.baja.driver.history.BArchiveDescriptor#historyId
   */
  public void setHistoryId(BHistoryId v) { set(historyId,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BArchiveDescriptor.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Is this descriptor enabled for archiving?
   */
  public boolean isEnabled()
  {
    return !getStatus().isDisabled();
  }
  
  /**
   * Get the parent history network extension.
   * The default implementation is to check the parent
   * device network for a child history network ext.
   * If not found, returns null.
   * 
   * @since Niagara 3.4
   */
  public BHistoryNetworkExt getHistoryNetworkExt()
  {
    BDeviceNetwork net = null;
    try
    {
      net = getNetwork();
    }
    catch(NotRunningException e)
    { // suppress NotRunningExceptions
    }
    
    if (net == null)
    {
      BComplex parent = getParent();
      while (parent != null)
      {
        if (parent instanceof BDeviceNetwork)
        {
          net = (BDeviceNetwork)parent;
          if (!isRunning()) net.lease();
          break;
        }
        parent = parent.getParent();
      }
    }
    
    if (net != null)
    {
      Object[] exts = net.getChildren(BHistoryNetworkExt.class);
      if ((exts != null) && (exts.length > 0))
        return (BHistoryNetworkExt)exts[0];
    }
    return null;
  }
}
