/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.driver;

import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BDriverContainer is used by convention to store all BDeviceNetworks
 * in a station database.
 *
 * @author    Brian Frank
 * @creation  18 Dec 03
 * @version   $Revision: 2$ $Date: 1/5/04 5:22:27 PM EST$
 * @since     Baja 1.0
 */
public class BDriverContainer
  extends BComponent
  implements BIService
{

  public Type[] getServiceTypes() { return new Type[] { TYPE }; }
  public void serviceStarted() throws Exception {}
  public void serviceStopped() throws Exception {}

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDriverContainer.class);
  
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("deviceNetwork.png");

}
