/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfSerial.comm;

import javax.baja.util.Lexicon;

/**
 * This class contains methods and attributes that help clean up other areas
 * of the source code that are used to display localized text.
 * 
 * @author lperkins
 */public class DdfSerialDriverCommLexicon
{
  public static final Lexicon LEX = Lexicon.make(DdfSerialDriverCommLexicon.class);
  
  
  
  // This message is placed on the property sheet of the user's custom version of
  // BDdfSerialNetwork if the systems integrator has not specified a serial port on the property sheet 
  // NoPortSelected = No port selected for serial communication.
  public static final String NO_PORT_SELECTED = "NoPortSelected";
  
  public static final String noPortSelected = LEX.getText(NO_PORT_SELECTED);
  
  
  
  
  // This message is displayed if an error occurs after the systems integrator changes the serial port.
  public static final String REOPEN_PORT_EXCEPTION = "ReopenPortException";
  
  public static final String reopenPortException(Exception e)
  {
    return LEX.getText(REOPEN_PORT_EXCEPTION, new Object[]{e}); 
  }
  
  
  
  
  // This message is placed in the standard output log if tracing is enabled for the log
  // Whenever the systems integrator changes serial port parameters.
  // RestartingSerialComm = Restarting serial communications.
  public static final String RESTARTING_SERIAL_COMM = "RestartingSerialComm";
  
  public static final String restartingSerialComm = LEX.getText(RESTARTING_SERIAL_COMM);
  
  
  
  
  // This error message is placed in the standard output log if for any reason, a serial
  // Port that needs to be opened cannot be opened. The value for parameter {0} is a descriptino
  // of the error that occurred
  // ErrorOpeningSerialPort=Error opening and configuring the serial port: {0}
  public static final String ERROR_OPENING_SERIAL_PORT = "ErrorOpeningSerialPort";
  
  public static final String errorOpeningSerialPort(Exception e)
  { 
    return  LEX.getText(ERROR_OPENING_SERIAL_PORT, new Object[]{e}); 
  }
  
  
  
  
  // This error message is placed in the standard output log if for an unexpected reason the driver
  // Could not close the standard Java InputStream that is connected to the serial port
  // UnableToCloseSerialInputStream = Unable to close serial input stream.
  public static final String UNABLE_TO_CLOSE_SERIAL_INPUT_STREAM = "UnableToCloseSerialInputStream";
  
  public static final String unableToCloseSerialInputStream = LEX.getText(UNABLE_TO_CLOSE_SERIAL_INPUT_STREAM);
  
  
  
  
  // This error message is placed in the standard output log if for an unexpected reason the driver
  // Could not close the standard Java OutputStream that is connected to the serial port
  // UnableToCloseSerialOutputStream = Unable to close serial output stream.
  public static final String UNABLE_TO_CLOSE_SERIAL_OUTPUT_STREAM = "UnableToCloseSerialOutputStream";
  
  public static final String unableToCloseSerialOutputStream = LEX.getText(UNABLE_TO_CLOSE_SERIAL_OUTPUT_STREAM);
}
