/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfSerial.comm;

import java.io.PrintWriter;
import java.io.StringWriter;

import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.nre.util.ByteArrayUtil;

import com.tridium.ddf.comm.defaultComm.BDdfTransmitter;
import com.tridium.ddf.comm.req.BIDdfRequest;

/**
 * This is a default serial transmitter whose forceTransmit method
 * writes the byte array version of the BIDdfRequest onto the output
 * stream that is tied to the serial port.
 *
 * @author lperkins
 *
 */
public class BDdfSerialTransmitter
  extends BDdfTransmitter
{
  /*-
   class BDdfSerialTransmitter
   {
     properties
     {
       maxRetryCount : int
         -- This is the default maximum number of times that any one message will ever be
         -- retransmitted
         default{[2]}
         slotfacets{[BFacets.make(BFacets.MIN,BInteger.make(0))]}

     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfSerial.comm.BDdfSerialTransmitter(1795590770)1.0$ @*/
/* Generated Wed Apr 04 17:05:01 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "maxRetryCount"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>maxRetryCount</code> property.
   * This is the default maximum number of times that any
   * one message will ever be retransmitted
   * @see com.tridium.ddfSerial.comm.BDdfSerialTransmitter#getMaxRetryCount
   * @see com.tridium.ddfSerial.comm.BDdfSerialTransmitter#setMaxRetryCount
   */
  public static final Property maxRetryCount = newProperty(0, 2,BFacets.make(BFacets.MIN,BInteger.make(0)));

  /**
   * Get the <code>maxRetryCount</code> property.
   * @see com.tridium.ddfSerial.comm.BDdfSerialTransmitter#maxRetryCount
   */
  public int getMaxRetryCount() { return getInt(maxRetryCount); }

  /**
   * Set the <code>maxRetryCount</code> property.
   * @see com.tridium.ddfSerial.comm.BDdfSerialTransmitter#maxRetryCount
   */
  public void setMaxRetryCount(int v) { setInt(maxRetryCount,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfSerialTransmitter.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// BDdfTransmitter
////////////////////////////////////////////////////////////////
  public void forceTransmit(BIDdfRequest ddfRequest) throws Exception
  {
    byte[] out = ddfRequest.toByteArray();
    if (getDdfCommunicator().getLog().isTraceOn())
      trace(out);
    getSerialCommunicator().getSerialOutputStream().write(out);
  }

////////////////////////////////////////////////////////////////
// BDdfSerialTransmitter
////////////////////////////////////////////////////////////////


  public BDdfSerialCommunicator getSerialCommunicator()
  {
    return (BDdfSerialCommunicator)getDdfCommunicator();
  }

  private void trace(byte[] out)
  {
    StringWriter sw = new StringWriter();
    PrintWriter pw = new PrintWriter(sw);
    pw.println("TX:");
    ByteArrayUtil.hexDump(pw,out,0,out.length);
    pw.flush();
    pw.close();
    getDdfCommunicator().getLog().trace(sw.toString());
  }
}
