/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfSerial.comm;

import java.io.InputStream;

import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.comm.defaultComm.BDdfReceiver;

/**
 * The BDdfSerialReceiver class implements the readByte
 * method and returns the next byte from the serial port's
 * input stream.
 * 
 * All this leaves for the subclass to implement are the following
 * three methods. 
 * 1.) checkFrame
 * 2.) isCompleteFrame
 * 3.) isStartOfFrame
 * 
 * @author lperkins
 *
 */
public abstract class BDdfSerialReceiver
  extends BDdfReceiver
{
  /*-
    class BDdfSerialReceiver
    {
    }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfSerial.comm.BDdfSerialReceiver(1772968220)1.0$ @*/
/* Generated Wed Apr 04 17:05:01 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfSerialReceiver.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
////////////////////////////////////////////////////////////////
// BDdfSerialReceiver
////////////////////////////////////////////////////////////////
  public void startReceiver()
  {
    in = getSerialCommunicator().getSerialInputStream();
    super.startReceiver();
  }
  
  public void stopReceiver()
  {
    in = null;
    super.stopReceiver();
  }
  
  protected int readByte() throws Exception
  {
    int b = -1;
    while (b==-1)
      b = in.read();
    return b;
  }

////////////////////////////////////////////////////////////////
// BDdfSerialReceiver
////////////////////////////////////////////////////////////////
  
  public BDdfSerialCommunicator getSerialCommunicator()
  {
    return (BDdfSerialCommunicator)getDdfCommunicator();
  }
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  InputStream in = null;
}
