/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfSerial.comm;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;

import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.log.Log;
import javax.baja.serial.BISerialHelperParent;
import javax.baja.serial.BISerialPort;
import javax.baja.serial.BISerialService;
import javax.baja.serial.BSerialHelper;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.BDdfCommDevice;
import com.tridium.ddf.BDdfCommNetwork;
import com.tridium.ddf.comm.BIDdfCommunicating;
import com.tridium.ddf.comm.defaultComm.BDdfCommunicator;
import com.tridium.ddf.comm.defaultComm.BDdfReceiver;
import com.tridium.ddf.comm.defaultComm.BDdfTransmitter;
import com.tridium.ddfSerial.BDdfSerialNetwork;

/**
 * Please extend BDdfSerialMutCommunicator or BDdfSerialSitCommunicator.
 *
 * @author lperkins
 *
 */
public class BDdfSerialCommunicator
  extends BDdfCommunicator
  implements BISerialHelperParent
{
  /*-
  class BDdfSerialCommunicator
  {
     properties
     {
       serialPortParameters : BSerialHelper
         -- This is where the integrator chooses the comm port, baud rate,
         -- And other serial port parameters
         default {[new BSerialHelper() ]}
       transmitter : BDdfTransmitter
         -- This item transmits messages over the serial port for the communicator.
         default{[ new BDdfSerialTransmitter() ]}
       receiver : BDdfReceiver
         -- This item receives message frames from the serial port for the communicator.
         -- The descendant class needs redefine this property and  specify its own
         -- version of a BDdfSerialReceiver as the default value for the redefined
         -- property.
         default{[ new BDdfSerialNullReceiver() ]}
     }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfSerial.comm.BDdfSerialCommunicator(3157104716)1.0$ @*/
/* Generated Wed Apr 04 17:05:01 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "serialPortParameters"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>serialPortParameters</code> property.
   * This is where the integrator chooses the comm port,
   * baud rate, And other serial port parameters
   * @see com.tridium.ddfSerial.comm.BDdfSerialCommunicator#getSerialPortParameters
   * @see com.tridium.ddfSerial.comm.BDdfSerialCommunicator#setSerialPortParameters
   */
  public static final Property serialPortParameters = newProperty(0, new BSerialHelper(),null);

  /**
   * Get the <code>serialPortParameters</code> property.
   * @see com.tridium.ddfSerial.comm.BDdfSerialCommunicator#serialPortParameters
   */
  public BSerialHelper getSerialPortParameters() { return (BSerialHelper)get(serialPortParameters); }

  /**
   * Set the <code>serialPortParameters</code> property.
   * @see com.tridium.ddfSerial.comm.BDdfSerialCommunicator#serialPortParameters
   */
  public void setSerialPortParameters(BSerialHelper v) { set(serialPortParameters,v,null); }

////////////////////////////////////////////////////////////////
// Property "transmitter"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>transmitter</code> property.
   * This item transmits messages over the serial port for the communicator.
   * @see com.tridium.ddfSerial.comm.BDdfSerialCommunicator#getTransmitter
   * @see com.tridium.ddfSerial.comm.BDdfSerialCommunicator#setTransmitter
   */
  public static final Property transmitter = newProperty(0, new BDdfSerialTransmitter(),null);

  /**
   * Get the <code>transmitter</code> property.
   * @see com.tridium.ddfSerial.comm.BDdfSerialCommunicator#transmitter
   */
  public BDdfTransmitter getTransmitter() { return (BDdfTransmitter)get(transmitter); }

  /**
   * Set the <code>transmitter</code> property.
   * @see com.tridium.ddfSerial.comm.BDdfSerialCommunicator#transmitter
   */
  public void setTransmitter(BDdfTransmitter v) { set(transmitter,v,null); }

////////////////////////////////////////////////////////////////
// Property "receiver"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>receiver</code> property.
   * This item receives message frames from the serial port for the communicator. The descendant class needs redefine this property and  specify its own version of a BDdfSerialReceiver as the default value for the redefined property.
   * @see com.tridium.ddfSerial.comm.BDdfSerialCommunicator#getReceiver
   * @see com.tridium.ddfSerial.comm.BDdfSerialCommunicator#setReceiver
   */
  public static final Property receiver = newProperty(0, new BDdfSerialNullReceiver(),null);

  /**
   * Get the <code>receiver</code> property.
   * @see com.tridium.ddfSerial.comm.BDdfSerialCommunicator#receiver
   */
  public BDdfReceiver getReceiver() { return (BDdfReceiver)get(receiver); }

  /**
   * Set the <code>receiver</code> property.
   * @see com.tridium.ddfSerial.comm.BDdfSerialCommunicator#receiver
   */
  public void setReceiver(BDdfReceiver v) { set(receiver,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfSerialCommunicator.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
  public BDdfSerialCommunicator()
  { // Sets 'COM1' as the default comm port. This works because the
    // constructors in Niagara AX are called before the database
    // values are loaded.
    getSerialPortParameters().setPortName("COM1");
  }
  
////////////////////////////////////////////////////////////////
// BComplex
////////////////////////////////////////////////////////////////
  
  /**
   * This must be under a BDdfSerialNetwork in the navigation tree of the Niagara AX station.
   */
  public boolean isParentLegal(BComponent parent)
  {
    return parent instanceof BDdfSerialNetwork;
  }

////////////////////////////////////////////////////////////////
// BComponent
////////////////////////////////////////////////////////////////
  
  public void descendantsStarted() throws Exception
  {
    // Initializes the port name as that from the serialPortParameters descendant
    portName=getSerialPortParameters().getPortName();
    super.descendantsStarted();
  }
  
////////////////////////////////////////////////////////////////
// BISerialHelperParent
////////////////////////////////////////////////////////////////
  
  public void reopenPort()
  {
    BIDdfCommunicating commParent = getDdfCommunicatingParent();
    
    // Disables so that we can re-enable...we do this to make it look like the
    // communicating network or communicating device is being re-enabled. This
    // should force the tuning policy to rewrite any driver control points
    // whose tuning policy calls for a writeOnEnabled. This is an enhancement
    // over basicDriver which does not re-assert any control logic simply by
    // changing the serial port
    if (commParent instanceof BDdfCommNetwork)
      ((BDdfCommNetwork)commParent).setEnabled(false);
    else if (commParent instanceof BDdfCommDevice)
      ((BDdfCommDevice)commParent).setEnabled(false);
    
    // Stops any threads that this communicator component or any of its Niagara
    // AX nav descendants requires
    stopCommunicating();
    
    // Closes the serial port, nulls out the serialIn and serialOut streams.
    closeSerialPort();
    
    try
    {
      // Attempts to open the new serial port by name. If the given portName does
      // not map to a serial port on the host computer then the 'openSerialPort'
      // method calls 'configFail' on the communicating network or communicating
      // device.
      openSerialPort();
      
      // Starts any threads that this communicator component or any of its Niagar 
      // AX nav descendants requires
      startCommunicating();
      
      // Possibly transfers settings from the previous comm port's log to the new comm
      // port's log.
      updatePortSettings();
      
      // Re-enables...we do this to make it look like the network / device was
      // just re-enabled. This should force the tuning policy to rewrite any
      // driver control points that whose tuning policy calls for a writeOnEnabled
      if (commParent instanceof BDdfCommNetwork)
        ((BDdfCommNetwork)commParent).setEnabled(true);
      else if (commParent instanceof BDdfCommDevice)
        ((BDdfCommDevice)commParent).setEnabled(true);
    }
    catch (Exception e)
    {
      getLog().error(DdfSerialDriverCommLexicon.reopenPortException(e));
      closeSerialPort();
    }
  }
  
////////////////////////////////////////////////////////////////
// BDdfCommunicator
////////////////////////////////////////////////////////////////
  
  /**
   * Although this method is declared to be final, descendants
   * may override the <i>serialCommunicatorStarted</i> method.
   */
  public final void communicatorStarted() throws Exception
  {
    try
    {
      openSerialPort();
      serialCommunicatorStarted();
    }
    catch (Exception e)
    {
      handleOpenSerialPortException(e);
      throw e;
    }
  }


  /**
   * This method is called by BDdfCommunicator when the component completely shuts down. Components shut down if the
   * station is stopped or if they are removed from the station database.
   * 
   * Although this method is declared to be final, descendants
   * may override the <i>serialCommunicatorStopped</i> method.
   */
  public final void communicatorStopped() throws Exception
  {
    closeSerialPort();
    serialCommunicatorStopped();
  }

  /**
   * Names the communicator's log according to the serial port name.
   */  
  public Log getLog()
  {
    return Log.getLog(getParent().getName()+'_'+portName);
  }
  
////////////////////////////////////////////////////////////////
// BDdfSerialCommunicator
////////////////////////////////////////////////////////////////

  public BDdfSerialNetwork getDdfSerialNetwork()
  {
    return (BDdfSerialNetwork) getParent();
  }
  
  public InputStream getSerialInputStream()
  {
    return serialIn;
  }
  public OutputStream getSerialOutputStream()
  {
    return serialOut;
  }
  
  /**
   * This method is called immediately after the Ddf Serial Communicator is started.
   */
  protected void serialCommunicatorStarted(){}

  /**
   * This method is called immediately after the Ddf Serial Communicator is stopped.
   */
  protected void serialCommunicatorStopped(){}
  
////////////////////////////////////////////////////////////////
// BDdfSerialCommunicator - Serial Port Management
////////////////////////////////////////////////////////////////
  
  private void _configFail(BComplex commParent, String reason)
  {
    if (commParent instanceof BDevice)
      ((BDevice)commParent).configFail(reason);
    else if (commParent instanceof BDeviceNetwork)
      ((BDeviceNetwork)commParent).configFail(reason);
    else
      getLog().error( reason );
  }
  
  private void _configOk(BComplex commParent)
  {
    if (commParent instanceof BDevice)
      ((BDevice)commParent).configOk();
    else if (commParent instanceof BDeviceNetwork)
      ((BDeviceNetwork)commParent).configOk();
    else
      getLog().message( DdfSerialDriverCommLexicon.LEX.getText("OpenSerialPortSuccess"));
  }
  
  /**
   * Opens the serial port, initializes the serialIn input stream, and
   * initializes the serialOut output stream
   * 
   * @throws Exception
   */
  protected void openSerialPort()
    throws Exception
  {
    // Finds the BIDdfCommunicating Nav ancestor. This is needed for 'faultCause' reporting and for
    // reporting the owner of the serial port if this succeeds.
    BComplex commParent = getParent();
    while ((commParent !=null) && (! (commParent instanceof BIDdfCommunicating )) )
    {
      commParent = commParent.getParent();
    }
    
    // Sanity check
    if (commParent == null)
    {
      getLog().error(DdfSerialDriverCommLexicon.LEX.getText("SerialCommunicatorNotUnderBIDdfCommunicating", new Object[]{getSlotPath()}));
      
      // Next, this falls through and exits
    }
    else
    {
      // If port not spedivied
      if (getSerialPortParameters().getPortName().equals(BSerialHelper.noPort))
      {
        _configFail(commParent,DdfSerialDriverCommLexicon.noPortSelected);
      }
      else
      {
        try
        {
          BISerialService platSvc = (BISerialService)Sys.getService(BISerialService.TYPE);
          
          serialPort = getSerialPortParameters().open(commParent.getName());
          serialPort.enableReceiveTimeout(platSvc.getMinTimeout());
          
          serialIn = new BufferedInputStream(serialPort.getInputStream(),
                                             getSerialRxBufferSize());
          serialOut = serialPort.getOutputStream();
          
          // Finds the BIDdfCommunicating Nav ancestor
          BComplex navParent = getParent();
          while ((navParent !=null) && (! (navParent instanceof BIDdfCommunicating )) )
          {
            navParent = navParent.getParent();
          }
          _configOk(commParent);
        }
        catch (Exception e)
        {
          _configFail(commParent, DdfSerialDriverCommLexicon.errorOpeningSerialPort(e));
          
          serialIn=null;
          serialOut=null;
          
          if (serialPort!=null)
          {
            try
            {
              serialPort.close();
            }
            finally
            {
              serialPort=null;
            }
          }
        }
      }
    }
  }
  
  /**
   * Override point to specify the buffer size for 'serialIn'
   * 
   * The 'serialIn' is a buffered input stream that wraps the serial
   * port's input stream.
   * 
   * Unless overridden, this returns DEFAULT_SERIAL_RX_BUFFER_SIZE (4096).
   * 
   * @return the buffer size in bytes for 'serialIn'
   */
  protected int getSerialRxBufferSize()
  {
    return DEFAULT_SERIAL_RX_BUFFER_SIZE;
  }
  
  protected void handleOpenSerialPortException(Exception e)
  {
    getLog().error(DdfSerialDriverCommLexicon.errorOpeningSerialPort(e));

    closeSerialPort();
  }
  
  protected void closeSerialInputStream()
  {
    if (serialIn != null)
    {
      try
      {
        serialIn.close();
      }
      catch (Exception x)
      {
        getLog().error(DdfSerialDriverCommLexicon.unableToCloseSerialInputStream, x);
      }
    }
  }
  
  protected void closeSerialOutputStream()
  {
    if (serialOut != null)
    {
      try
      {
        serialOut.close();
      }
      catch (Exception x)
      {
        getLog().error(DdfSerialDriverCommLexicon.unableToCloseSerialOutputStream, x);
      }
    }
  }

  protected void closeSerialPort()
  {
    if(serialPort != null) serialPort.close(); // NOTE: Must close serial port first, otherwise, QNX deadlocks.
    serialPort=null;
    serialIn=null;
    serialOut=null;
    
    // 10/15/2007:
    // Commenting out per issue 10970: BufferedInputStream on QNX implementation synchronizes
    // the 'read' method and 'stop' method which causes deadlock in embedded Jace 2
    //closeSerialInputStream();
    // Issue 10970: Commenting out the buffered output stream too. I do not know if it specifically
    // causes a deadlock, as its counterpart does, however, I am going to be consistant and comment
    // the following line of code too. After closing the serial port, the input and output streams
    // will have to just allow everything to work out. In truth, we are not using a buffered output
    // stream though....but I will be consistent here too.
    //closeSerialOutputStream();
  }


  
  /**
   * This method is called from the reopenPort method.
   */
  private void updatePortSettings()
  {
    // The newPortName is the new value of the 'portName' property
    String newPortName = getSerialPortParameters().getPortName();
    
    // Checks the instance variable "this.portName" (in case changed is called before descendantsStarted where this.portName
    // is initialized)        
    if (this.portName!=null) 
    {
      // The previousPortName is whatever is stored in the 'portName' instance variable that we initialized in
      // descendantsStarted()
      String previousPortName = portName;
      
      // If the serial port name really did change
      if (!(previousPortName.equals(newPortName)))
      {
        // Retrieves the previous log by its name. Its name would have been the parent component's name plus underscore plus
        // previousPortName
        Log previousLog = Log.getLog(getParent().getName()+'_'+previousPortName);
        
        if (previousLog!=null) // Paranoia!
        {
          // Retrieves the new log by its name. Its name will be the parent component's name plus underscore plus newPortName
          Log newerLog = Log.getLog(getParent().getName()+'_'+newPortName);
          
          if (newerLog!=null) // Paranoia!
          {
            // Verifies that the severity of the newer log is further from  "TRACE" than the previous log settings. The
            // newer log could have pre-existing settings if the user sets the COM port back to something that it was previously.
            // If the newer log is a brand-new log, then its 'severity' defaults to "MESSAGE" (as is the case for all new logs
            // in Niagara AX). This extra logic verifies that we never set the severity of the newer log any further away from
            // 'TRACE' than it was before this call-back occurred. We only want to automatically adjust the severity setting of
            // the newer log in order to set it closer to 'TRACE' -- and even then, we only want to do this if the previous log
            // severity was closer to "TRACE" than the newer log severity would otherwise be if we were not to intervene.
            int newLogSeverity = newerLog.getSeverity(); 
            int previousLogSeverity = previousLog.getSeverity();
            
            if (newLogSeverity>previousLogSeverity) // If the newer log's severity is further away from 'TRACE' than the
            {                                       // previous log settings...
              // Transfers the severity setting from the previous log to the new log (making the new log severity  be closer to
              // 'TRACE' thereby matching the severity setting of the previous log.)
              newerLog.setSeverity( previousLog.getSeverity() ); 
            }
          }
        }
      }
      // Stores the portName so that this logic can work again if the portName is changed again
      this.portName=newPortName;
    }
    
  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  /**
   * This is the default buffer size (4096) for 'serialIn'. 
   */
  public static final int DEFAULT_SERIAL_RX_BUFFER_SIZE = 4096;
  
  /**
   * This is a direct reference to the BISerialPort.
   */
  protected BISerialPort serialPort=null;

  /**
   * This is a direct reference to the input stream that is tied
   * to the BISerialPort.
   */
  protected InputStream serialIn=null;
  
  /**
   * This is a direct reference to the output stream that is tied
   * to the BISerialPort.
   */
  protected OutputStream serialOut=null;
  
  /**
   * This is the name of the serial port. We use this from the changed method to
   * preserve the log severity settings when the user changes the COM port (causing
   * a new log to be created)
   */
  private String portName = null;
  
}
