/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfSerial;

import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddfSerial.comm.multipleTransaction.BDdfSerialMutCommunicator;

/**
 * 
 * This communicator allows multiple outstanding requests on the serial port
 * at the same time. This accomodates serial/wireless radio protocols where
 * a wireless radio is connected to the Niagara AX station as a serial port.
 * 
 * This uses a multiple transaction manager to allow a request for data
 * to be transmitted onto the field bus even though the data response may arrive
 * much later. In the mean time, the multiple transaction manager will allow
 * other requests to be transmitted onto the field-bus. The responses for those
 * requests likewise could arrive later after which even more requests can
 * be transmitted onto the field-bus.   
 * 
 * This is a Niagara AX driver network that is designed for use with a
 * serial protocol that allows for the possibility of having mulitple outstanding
 * requests on the field-bus waiting for responses at any given time.
 * 
 * This redefines the "communicator" property from BDdfCommNetwork to use
 * a BDdfSerialMutCommunicator.
 * 
 * The acronynm "Mut" stands for "Multiple Transaction".
 * 
 * Your driver can extend this class, redefine the communicator property, and
 * specify a communicator for your driver that extends BDdfSerialMutCommunicator
 * and customizes (at the very least) the receiver.
 * 
 * @author lperkins
 */
@SuppressWarnings("cast")
public abstract class BDdfSerialMutNetwork
  extends BDdfSerialNetwork
{
  /*-
    class BDdfSerialMutNetwork
    {
      properties
      {
        communicator : BValue
          -- Uses a multiple-outstanding-transaction serial port communicator.
          -- The BValues for this property must implement BIDdfCommunicator 
          default{[ new BDdfSerialMutCommunicator() ]}
      }
    }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfSerial.BDdfSerialMutNetwork(4289898325)1.0$ @*/
/* Generated Wed Apr 04 17:05:01 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "communicator"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>communicator</code> property.
   * Uses a multiple-outstanding-transaction serial port
   * communicator. The BValues for this property must implement
   * BIDdfCommunicator
   * @see com.tridium.ddfSerial.BDdfSerialMutNetwork#getCommunicator
   * @see com.tridium.ddfSerial.BDdfSerialMutNetwork#setCommunicator
   */
  public static final Property communicator = newProperty(0, new BDdfSerialMutCommunicator(),null);
  
  /**
   * Get the <code>communicator</code> property.
   * @see com.tridium.ddfSerial.BDdfSerialMutNetwork#communicator
   */
  public BValue getCommunicator() { return (BValue)get(communicator); }
  
  /**
   * Set the <code>communicator</code> property.
   * @see com.tridium.ddfSerial.BDdfSerialMutNetwork#communicator
   */
  public void setCommunicator(BValue v) { set(communicator,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfSerialMutNetwork.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

}
