/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfIp.udp.comm;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Vector;

import javax.baja.status.BStatus;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.nre.util.Array;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

import com.tridium.ddf.comm.BIDdfCommunicator;

public class BDdfUdpMulticastHelper
  extends BVector
{
  /*-
    class BDdfUdpMulticastHelper
    {
      properties
      {
        status : BStatus
          -- Reports the status of the multicast socket.
          default {[BStatus.ok]}
        faultCause : BFormat
          -- Specifies the reason why the statusFlags are in fault, if they are in fault
          default {[ BFormat.DEFAULT ]}
        jaceIpAddress : String
          -- Specifies the local, Jace Udp/Ip address to bind the multicast socket to
          default{["localHost"]}
        jaceUdpPort : int
          -- Specifies the local, Jace Udp/Ip port to bind the multicast socket to
          default{[-1]}
        udpGroupAddresses : BVector
          -- The multicast socket will be bound to send and/or receive to/from
          -- these ip addresses
          default{[new BVector()]}
          slotfacets{[BFacets.make(BFacets.FIELD_EDITOR, "alarm:StringListFE")]}
      }
    }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfIp.udp.comm.BDdfUdpMulticastHelper(2176526279)1.0$ @*/
/* Generated Tue Jun 12 10:08:05 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "status"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>status</code> property.
   * Reports the status of the multicast socket.
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpMulticastHelper#getStatus
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpMulticastHelper#setStatus
   */
  public static final Property status = newProperty(0, BStatus.ok,null);

  /**
   * Get the <code>status</code> property.
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpMulticastHelper#status
   */
  public BStatus getStatus() { return (BStatus)get(status); }

  /**
   * Set the <code>status</code> property.
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpMulticastHelper#status
   */
  public void setStatus(BStatus v) { set(status,v,null); }

////////////////////////////////////////////////////////////////
// Property "faultCause"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>faultCause</code> property.
   * Specifies the reason why the statusFlags are in fault,
   * if they are in fault
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpMulticastHelper#getFaultCause
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpMulticastHelper#setFaultCause
   */
  public static final Property faultCause = newProperty(0, BFormat.DEFAULT,null);

  /**
   * Get the <code>faultCause</code> property.
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpMulticastHelper#faultCause
   */
  public BFormat getFaultCause() { return (BFormat)get(faultCause); }

  /**
   * Set the <code>faultCause</code> property.
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpMulticastHelper#faultCause
   */
  public void setFaultCause(BFormat v) { set(faultCause,v,null); }

////////////////////////////////////////////////////////////////
// Property "jaceIpAddress"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>jaceIpAddress</code> property.
   * Specifies the local, Jace Udp/Ip address to bind the
   * multicast socket to
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpMulticastHelper#getJaceIpAddress
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpMulticastHelper#setJaceIpAddress
   */
  public static final Property jaceIpAddress = newProperty(0, "localHost",null);

  /**
   * Get the <code>jaceIpAddress</code> property.
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpMulticastHelper#jaceIpAddress
   */
  public String getJaceIpAddress() { return getString(jaceIpAddress); }

  /**
   * Set the <code>jaceIpAddress</code> property.
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpMulticastHelper#jaceIpAddress
   */
  public void setJaceIpAddress(String v) { setString(jaceIpAddress,v,null); }

////////////////////////////////////////////////////////////////
// Property "jaceUdpPort"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>jaceUdpPort</code> property.
   * Specifies the local, Jace Udp/Ip port to bind the multicast socket to
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpMulticastHelper#getJaceUdpPort
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpMulticastHelper#setJaceUdpPort
   */
  public static final Property jaceUdpPort = newProperty(0, -1,null);

  /**
   * Get the <code>jaceUdpPort</code> property.
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpMulticastHelper#jaceUdpPort
   */
  public int getJaceUdpPort() { return getInt(jaceUdpPort); }

  /**
   * Set the <code>jaceUdpPort</code> property.
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpMulticastHelper#jaceUdpPort
   */
  public void setJaceUdpPort(int v) { setInt(jaceUdpPort,v,null); }

////////////////////////////////////////////////////////////////
// Property "udpGroupAddresses"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>udpGroupAddresses</code> property.
   * The multicast socket will be bound to send and/or receive to/from these ip addresses
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpMulticastHelper#getUdpGroupAddresses
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpMulticastHelper#setUdpGroupAddresses
   */
  public static final Property udpGroupAddresses = newProperty(0, new BVector(),BFacets.make(BFacets.FIELD_EDITOR, "alarm:StringListFE"));

  /**
   * Get the <code>udpGroupAddresses</code> property.
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpMulticastHelper#udpGroupAddresses
   */
  public BVector getUdpGroupAddresses() { return (BVector)get(udpGroupAddresses); }

  /**
   * Set the <code>udpGroupAddresses</code> property.
   * @see com.tridium.ddfIp.udp.comm.BDdfUdpMulticastHelper#udpGroupAddresses
   */
  public void setUdpGroupAddresses(BVector v) { set(udpGroupAddresses,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfUdpMulticastHelper.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  public BIDdfCommunicator getCommunicator()
  {
    BComplex parent = getParent();
    while (! (parent instanceof BIDdfCommunicator))
    {
      parent = parent.getParent();
    }
    return (BIDdfCommunicator)parent;
  }
  /**
   * Binds a MulticastSocket to the Jace's ip address and port. Configures
   * the multicast socket to be a member of all of the groupAddresses
   * that are configured in the 'Group Addresses' property.
   *
   * @return the bound MultiCast socket to the Jace's ip address and port
   * or null if a SocketException, UnknownHostException, or IOException occurs, in
   * which case, a message will be automatically sent to the communicator's
   * log.
   */
  public MulticastSocket getSocket()
  {
    try
    {
      if (multicastSocket==null)
      {
        multicastSocket = new MulticastSocket(getJaceUdpPort());
        multicastSocket.setInterface(InetAddress.getByName(getJaceIpAddress()));
        joinOrLeaveUdpGroups();
      }
      return multicastSocket;
    }
    catch (SocketException se)
    {
      setStatus(BStatus.fault);
      setFaultCause(formatJaceSocketConnectionError);
      getCommunicator().getLog().error(jaceSocketConnectionError,se);
    }
    catch (UnknownHostException uhe)
    {
      setStatus(BStatus.fault);
      setFaultCause(formatJaceUnknownHostException);
      getCommunicator().getLog().error(jaceUnknownHostException,uhe);
    }
    catch (IOException ioe)
    {
      setStatus(BStatus.fault);
      setFaultCause(formatJaceMulticastSocketOpenError);
      getCommunicator().getLog().error(jaceMulticastSocketOpenError,ioe);
    }
    return null;
  }

  public void closeSocket()
  {
    if (multicastSocket!=null)
    {
      multicastSocket.close();
      multicastSocket = null;
    }
  }

  private Vector<BString> multiCastGroups = null; // This vector keeps track of the groups that the multi-cast socket is currently joined to. Note that the 'Group Addresses' property are those groups that the user would like the socket to be bound to. This Vector will change in conjunction with changes to the 'Group Addresses' property

  /**
   * If the internal 'multicastSocket' is not null then this calls joinGroups followed by leaveGroups.
   */
  protected void joinOrLeaveUdpGroups()
  {
    if (multicastSocket!=null)
    {
      BString[] groups = getUdpGroupAddresses().getChildren(BString.class);
      joinUdpGroups(groups);
      leaveUdpGroups(groups);
    }
  }

   /**
    * Causes the MulticastSocket to join any new groups that are specified on the 'Group Addresses' property.
    *
    *  @param BString[] the groups to which the internal MulticastSocket needs to be joined.
    */
  protected void joinUdpGroups(BString[] groups)
  {
    if (multicastSocket!=null)
    {
      for (int i=0; i<groups.length; i++)
      { // Loops through each group address that the user or developer specifies
        if (!(multiCastGroups.contains(groups[i])))
        {  // Checks if any particular group address is not in the multiCastGroups vector
          try
          {
            multiCastGroups.addElement(groups[i]);
            multicastSocket.joinGroup(InetAddress.getByName(groups[i].getString()));
          }
          catch (IOException ioe)
          {
            setStatus(BStatus.fault);
            setFaultCause(formatInvalidMulticastGroup(groups[i],ioe));
            getCommunicator().getLog().error(invalidMulticastGroup,ioe);
          }
        }
      }
    }
  }
  /**
   * Causes the MulticastSocket to leave any groups that it has already joined that are not in the 'Group Addresses' property.
   *  @param BString[] the groups to which the internal MulticastSocket needs to be joined. The internal multicast socket will
   *  leave any group that the socket is a member of, that is not included among this array.
   */
  protected void leaveUdpGroups(BString[] groups)
  {
    Iterator<BString> joinedGroups = multiCastGroups.iterator();
    Array<BString> newGroups = new Array<>(groups);

    while (joinedGroups.hasNext())
    {
      BString group = joinedGroups.next();
      if (!(newGroups.contains(group)))
      {
        try
        {
          multicastSocket.leaveGroup(InetAddress.getByName(group.getString()));
        }
        catch (IOException ioe)
        {
          setStatus(BStatus.fault);
          setFaultCause(formatInvalidMulticastGroup(group,ioe));
          getCommunicator().getLog().error(invalidMulticastGroup,ioe);
        }
        joinedGroups.remove();

      }
    }
  }

  public void changed(Property property, Context context)
  {
    if (property.equals(udpGroupAddresses))
    {
      joinOrLeaveUdpGroups();
    }
    else if (property.equals(jaceIpAddress) ||
             property.equals(jaceUdpPort))
    {
      closeSocket();
    }
    super.changed(property, context);
  }

  protected MulticastSocket multicastSocket = null;

  public static final Lexicon LEX = Lexicon.make(BDdfUdpMulticastHelper.class);

  // LEXICON string keys
  public static final String lexkeyJaceMulticastSocketOpenError = "JaceMulticastSocketOpenError";
  public static final String lexkeyJaceSocketConnectionError = "JaceSocketConnectionError";
  public static final String lexkeyJaceUnknownHostException = "JaceUnknownHostException";
  public static final String lexkeyInvalidGroup = "InvalidMulticastGroup";
  // The corresponding server-side lexicon values
  public static final String jaceMulticastSocketOpenError = LEX.getText(lexkeyJaceMulticastSocketOpenError);
  public static final String jaceSocketConnectionError = LEX.getText(lexkeyJaceSocketConnectionError);
  public static final String jaceUnknownHostException = LEX.getText(lexkeyJaceUnknownHostException);
  public static final String invalidMulticastGroup = LEX.getText(lexkeyInvalidGroup);
  // The BFormats to resolve the client-side lexicon values
  public static final String formatLexicon = "lexicon(devUdpDriver:";
  /** Inserts the given lexkey into a BFormat lexicon(module:key) string */
  public static String formatLexicon(String lexkey){return formatLexicon + lexkey + ')';}
  public static final BFormat formatJaceMulticastSocketOpenError = BFormat.make(formatLexicon(lexkeyJaceMulticastSocketOpenError));
  public static final BFormat formatJaceSocketConnectionError = BFormat.make(formatLexicon(lexkeyJaceSocketConnectionError));
  public static final BFormat formatJaceUnknownHostException = BFormat.make(formatLexicon(lexkeyJaceUnknownHostException));
  public static final BFormat formatInvalidMulticastGroup(BString g, Exception e){return BFormat.make(g.toString() + ':'+ formatLexicon(lexkeyInvalidGroup)+':'+e);}

}
