/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfIp.udp;

import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.BDdfDevice;

/**
 * BDdfUdpDeviceBehindGateway - Devices that extend this device should reside
 * under a BDdfUdpGatewayNetwork in the Niagara-AX Nav Tree. The Niagara-AX Udp/Ip connection is on the BDdfUdpGatewayNetwork
 * and is shared by all BDdfUdpDeviceBehindGateway devices.
 * 
 * In general, this is used to represent a field device that is physically connected
 * to a field-bus, where the field-ubs is connected to a gateway unit, which is connected to a Udp/Ip network.
 *
 * @author    lperkins
 * @creation  Oct 18, 2006
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public abstract class BDdfUdpDeviceBehindGateway
  extends BDdfDevice
{
  /*-
   class BDdfUdpDeviceBehindGateway
   {
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfIp.udp.BDdfUdpDeviceBehindGateway(2839513770)1.0$ @*/
/* Generated Tue Jun 12 10:08:05 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfUdpDeviceBehindGateway.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


}
