/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfIp.udp;

import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.BDdfCommDevice;
import com.tridium.ddfIp.udp.comm.BDdfUdpCommunicator;

/**
 * Developers should extend from this class if their driver communicates
 * to field-devices that have their own Ethernet port directly on them.
 * 
 * @author lperkins
 */
public abstract class BDdfUdpDevice
  extends BDdfCommDevice
{
  /*-
  class BDdfUdpDevice
  {
    properties
    {
      communicator : BValue
        -- This component communicates on behalf of this device
        -- The BValues for this property must implement BIDdfCommunicator 
        default{[ new BDdfUdpCommunicator() ]}
    }  
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfIp.udp.BDdfUdpDevice(4287499865)1.0$ @*/
/* Generated Tue Jun 12 10:08:05 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "communicator"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>communicator</code> property.
   * This component communicates on behalf of this device
   * The BValues for this property must implement BIDdfCommunicator
   * @see com.tridium.ddfIp.udp.BDdfUdpDevice#getCommunicator
   * @see com.tridium.ddfIp.udp.BDdfUdpDevice#setCommunicator
   */
  public static final Property communicator = newProperty(0, new BDdfUdpCommunicator(),null);
  
  /**
   * Get the <code>communicator</code> property.
   * @see com.tridium.ddfIp.udp.BDdfUdpDevice#communicator
   */
  public BValue getCommunicator() { return get(communicator); }
  
  /**
   * Set the <code>communicator</code> property.
   * @see com.tridium.ddfIp.udp.BDdfUdpDevice#communicator
   */
  public void setCommunicator(BValue v) { set(communicator,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfUdpDevice.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

}
