/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfIp.tcp.comm.singleTransaction;

import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.comm.defaultComm.BDdfTransactionMgr;
import com.tridium.ddf.comm.singleTransaction.BDdfSingleTransactionMgr;
import com.tridium.ddfIp.tcp.comm.BDdfTcpCommunicator;

/**
 * This is a simpler version of the BDdfTcpCommunicator because it uses
 * a BDdfSingleTransactionMgr that which behaves in a master-slave
 * fashion. It transmits a request and waits for the response before
 * transmitting the next request.
 * 
 * For more details, please review the Java Doc for com.tridium.ddf.comm.singleTransaction.BDdfSingleTransactionMgr
 * 
 * @author lperkins
 *
 */public class BDdfTcpSitCommunicator
  extends BDdfTcpCommunicator
{
  /*-
  class BDdfTcpSitCommunicator
  {
    properties
    {
      transactionManager : BDdfTransactionMgr
        -- Customizes to use the standard BDdfSingleTransactionMgr
        default{[ new BDdfSingleTransactionMgr() ]}       
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfIp.tcp.comm.singleTransaction.BDdfTcpSitCommunicator(3677793132)1.0$ @*/
/* Generated Tue Dec 11 13:21:53 EST 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "transactionManager"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>transactionManager</code> property.
   * Customizes to use the standard BDdfSingleTransactionMgr
   * @see com.tridium.ddfIp.tcp.comm.singleTransaction.BDdfTcpSitCommunicator#getTransactionManager
   * @see com.tridium.ddfIp.tcp.comm.singleTransaction.BDdfTcpSitCommunicator#setTransactionManager
   */
  public static final Property transactionManager = newProperty(0, new BDdfSingleTransactionMgr(),null);
  
  /**
   * Get the <code>transactionManager</code> property.
   * @see com.tridium.ddfIp.tcp.comm.singleTransaction.BDdfTcpSitCommunicator#transactionManager
   */
  public BDdfTransactionMgr getTransactionManager() { return (BDdfTransactionMgr)get(transactionManager); }
  
  /**
   * Set the <code>transactionManager</code> property.
   * @see com.tridium.ddfIp.tcp.comm.singleTransaction.BDdfTcpSitCommunicator#transactionManager
   */
  public void setTransactionManager(BDdfTransactionMgr v) { set(transactionManager,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfTcpSitCommunicator.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

}
