/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.ddfIp.tcp.comm;

import javax.baja.log.Log;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.comm.defaultComm.BDdfReceiver;
import com.tridium.ddf.comm.defaultComm.BDdfTransmitter;
import com.tridium.ddfIp.comm.BDdfIpCommunicator;

public class BDdfTcpCommunicator
  extends BDdfIpCommunicator
{
  /*-
   class BDdfTcpCommunicator
   {
     properties
     {
       tcpIpComm : BDdfTcpHelper
         -- The Tcp/Ip settings for this communicator.
         default{[new BDdfTcpHelper()]}
         slotfacets{[MGR_INCLUDE]} 
       transmitter : BDdfTransmitter
         default{[new BDdfTcpTransmitter()]}
       receiver : BDdfReceiver
         default{[new BDdfTcpNullReceiver()]}
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfIp.tcp.comm.BDdfTcpCommunicator(1659331890)1.0$ @*/
/* Generated Tue Jun 12 10:08:05 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "tcpIpComm"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>tcpIpComm</code> property.
   * The Tcp/Ip settings for this communicator.
   * @see com.tridium.ddfIp.tcp.comm.BDdfTcpCommunicator#getTcpIpComm
   * @see com.tridium.ddfIp.tcp.comm.BDdfTcpCommunicator#setTcpIpComm
   */
  public static final Property tcpIpComm = newProperty(0, new BDdfTcpHelper(),MGR_INCLUDE);
  
  /**
   * Get the <code>tcpIpComm</code> property.
   * @see com.tridium.ddfIp.tcp.comm.BDdfTcpCommunicator#tcpIpComm
   */
  public BDdfTcpHelper getTcpIpComm() { return (BDdfTcpHelper)get(tcpIpComm); }
  
  /**
   * Set the <code>tcpIpComm</code> property.
   * @see com.tridium.ddfIp.tcp.comm.BDdfTcpCommunicator#tcpIpComm
   */
  public void setTcpIpComm(BDdfTcpHelper v) { set(tcpIpComm,v,null); }

////////////////////////////////////////////////////////////////
// Property "transmitter"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>transmitter</code> property.
   * @see com.tridium.ddfIp.tcp.comm.BDdfTcpCommunicator#getTransmitter
   * @see com.tridium.ddfIp.tcp.comm.BDdfTcpCommunicator#setTransmitter
   */
  public static final Property transmitter = newProperty(0, new BDdfTcpTransmitter(),null);
  
  /**
   * Get the <code>transmitter</code> property.
   * @see com.tridium.ddfIp.tcp.comm.BDdfTcpCommunicator#transmitter
   */
  public BDdfTransmitter getTransmitter() { return (BDdfTransmitter)get(transmitter); }
  
  /**
   * Set the <code>transmitter</code> property.
   * @see com.tridium.ddfIp.tcp.comm.BDdfTcpCommunicator#transmitter
   */
  public void setTransmitter(BDdfTransmitter v) { set(transmitter,v,null); }

////////////////////////////////////////////////////////////////
// Property "receiver"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>receiver</code> property.
   * @see com.tridium.ddfIp.tcp.comm.BDdfTcpCommunicator#getReceiver
   * @see com.tridium.ddfIp.tcp.comm.BDdfTcpCommunicator#setReceiver
   */
  public static final Property receiver = newProperty(0, new BDdfTcpNullReceiver(),null);
  
  /**
   * Get the <code>receiver</code> property.
   * @see com.tridium.ddfIp.tcp.comm.BDdfTcpCommunicator#receiver
   */
  public BDdfReceiver getReceiver() { return (BDdfReceiver)get(receiver); }
  
  /**
   * Set the <code>receiver</code> property.
   * @see com.tridium.ddfIp.tcp.comm.BDdfTcpCommunicator#receiver
   */
  public void setReceiver(BDdfReceiver v) { set(receiver,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfTcpCommunicator.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// BDdfCommunicator
////////////////////////////////////////////////////////////////
  
  /**
   * Adds the IP address and port to the communicator log name.
   */
  public Log getLog()
  {
    // Fails safely if the parent becomes null. This might happen
    // during client-side video stream communications if the Niagara
    // core attempts to cleanup the proxy version of this object.
    // Even if and after that occurs, this object needs to still be
    // able to function with throwing a null pointer exception.
    String n = getType().getTypeSpec().getTypeName();
    
    if (n!=null)
    {
      Object h = getHandle();
      
      if (h!=null)
      {
        n = n + ".h" + h;
      }
      return Log.getLog(n);//getTcpIpComm().getDestinationAddress().getIpPort());
    }
          // else, fall through and create a Log with a default name
    return Log.getLog(getName()+'_'+getTcpIpComm().getDestinationAddress().getIpPort());
  }

  /**
   * This method is called by the {@link #startCommunicating()}
   * method to encapsulate the start-up logic for this class.
   * 
   * @since Niagara AX 3.5
   */
  protected void startTcpCommunicating()
  {
    initSocketManager();
    
    if (getLog().isTraceOn())getLog().trace("Starting communications.");
    
    socketManager.startSocketManager();
    
    if (getLog().isTraceOn())getLog().trace("BDdfTcpCommunicator ["+this+"] started!");
  }
  
  public void startCommunicating()
  {
    startTcpCommunicating();
    
    super.startCommunicating();
  }  
  
////////////////////////////////////////////////////////////////
// BDdfIpCommunicator
////////////////////////////////////////////////////////////////
  
  /**
   * Although this method is declared as final, descendants may
   * override the <i>tcpCommunicatorStarted</i> method.
   */
  public final void ipCommunicatorStarted() throws Exception
  {
    
    tcpCommunicatorStarted();
  }
    

  /**
   * Although this method is declared as final, descendants may
   * override the <i>tcpCommunicatorStopped</i> method.
   */
  public final void ipCommunicatorStopped() throws Exception
  {
    socketManager.stopSocketManager();
    
    if (getLog().isTraceOn())getLog().trace("BDdfTcpCommunicator ["+this+"] stopped!");
    
    tcpCommunicatorStopped();
  }
  
////////////////////////////////////////////////////////////////
// TcpSocketManager
////////////////////////////////////////////////////////////////
  
  /**
   * Developers may override this method to plug-in a customized
   * version of the TcpSocketManager. 
   * 
   * Prior to Niagara AX 3.5, this logic was encapsulated in source code with
   * private access modifiers.
   * 
   * @since Niagara AX 3.5
   */
  protected TcpSocketManager makeSocketManager()
  {
    return new TcpSocketManager(this);
  }
  
  /**
   * Allocates the dedicated thread for the socket manager.
   * 
   * Prior to Niagara AX 3.5, this logic was encapsulated in source code with
   * private access modifiers.
   * 
   * @param socketManager the TcpSocketManager to run in the
   * dedicated thread
   * 
   * @return the new, unstarted, dedicated thread for the socket manager.
   * 
   * @since Niagara AX 3.5
   */
  protected Thread makeSocketManagerThread(TcpSocketManager socketManager)
  {
    return new Thread( socketManager, getLog().getLogName()+":TcpSoMan");
  }
  
  /**
   * Initializes the {@link #socketManager} and the {@link #socketManagerThread}.
   * 
   * Starts the {@link #socketManagerThread}.
   * 
   * Prior to Niagara AX 3.5, this logic was encapsulated in source code with
   * private access modifiers.
   * 
   * @since Niagara AX 3.5.
   */
  protected void initSocketManager()
  {
    socketManager       = makeSocketManager();
    
    socketManagerThread = makeSocketManagerThread(socketManager);

    if (getLog().isTraceOn())getLog().trace("starting new socket manager thread");
    socketManagerThread.start();
    
    //detailsLn("setting new receive thread to NORM_PRIORITY");
    //socketManagerThread.setPriority(Thread.MIN_PRIORITY); // 10/01/2002 : LPjr : Making thread min priority causes receive to not get responses fast enough when cpu utilization at 100% on VxWorks (at min priority, nothing gets cpu time when cpu being used 100% by other threads of normal priority, which includes ModbusAsyncRequest thread, ModbusPoll thread, etc.)
  }

  
  /**
   * @return TcpSocketManager
   */
  public TcpSocketManager getTcpSocketManager()
  {
    return socketManager;
  }  
  
  
////////////////////////////////////////////////////////////////
// BDdfTcpIpCommunicator
////////////////////////////////////////////////////////////////
  
  protected void tcpCommunicatorStarted()
    throws Exception
  {
  
  }
  
  protected void tcpCommunicatorStopped()
    throws Exception
  {
    
  }
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  /**
   * This is a direct reference to the internal socket manager. In
   * general, it is probably better to access this through its public
   * getter method {@link #getTcpSocketManager()}.
   * 
   * Prior to Niagara AX 3.5 access was restricted to private access.
   * 
   * @since Niagara AX 3.5
   */
  protected TcpSocketManager socketManager;
  
  /**
   * This is a direct reference to the thread for the internal socket
   * manager.
   * 
   * Prior to Niagara AX 3.5 access was restricted to private access.
   * 
   * @since Niagara AX 3.5
   */
  protected Thread socketManagerThread;
}
