/*
 * @copyright 2005 Tridium Inc.
 */
package com.tridium.ddfIp.tcp;

import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.ddf.BDdfCommNetwork;
import com.tridium.ddfIp.tcp.comm.multipleTransaction.BDdfTcpMutCommunicator;

/**
 * BDdfTcpGatewayNetwork is the driver network for devices that are behind
 * a Tcp/Ip gateway. A Tcp/Ip gateway is a unit of hardware that is connected to
 * a Tcp/Ip network and also to one or more generic field-buses. It forwards
 * Tcp/Ip communications from the Tcp/Ip network to other devices that are
 * connected to its generic field-bus(es).
 * 
 * In this type of installation, the BDdfTcpGatewayNetwork has a dedicated Tcp/Ip
 * connection in the Niagara AX station. The individual devices do not have their
 * own dedicated Tcp/Ip connection. Instead, the individual devices in the station
 * communicate through the BDdfTcpGatewayNetwork that is above them in the Niagara
 * AX navigation tree.
 *
 * @author    lperkins
 * @creation  Oct 18, 2006
 * @version   $Revision$ $Date$
 * @since     Niagara 3.2
 */
public abstract class BDdfTcpGatewayNetwork
  extends BDdfCommNetwork
{
  /*-
  class BDdfTcpGatewayNetwork
  {
    properties
    {
      communicator : BValue
        -- Places the Tcp/Ip communications directly onto the network. Devices
        -- Under this network should extend from BDdfTcpDeviceBehindGateway.
        -- BDdfTcpDeviceBehindGateway uses this communicator field communications
        -- To the actual physical device.
        default{[ new BDdfTcpMutCommunicator() ]} 
    }
  } 
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.tridium.ddfIp.tcp.BDdfTcpGatewayNetwork(2926741128)1.0$ @*/
/* Generated Tue Jun 12 10:08:05 EDT 2007 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "communicator"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>communicator</code> property.
   * Places the Tcp/Ip communications directly onto the
   * network. Devices Under this network should extend from BDdfTcpDeviceBehindGateway. BDdfTcpDeviceBehindGateway uses this communicator field communications To the actual physical device.
   * @see com.tridium.ddfIp.tcp.BDdfTcpGatewayNetwork#getCommunicator
   * @see com.tridium.ddfIp.tcp.BDdfTcpGatewayNetwork#setCommunicator
   */
  public static final Property communicator = newProperty(0, new BDdfTcpMutCommunicator(),null);
  
  /**
   * Get the <code>communicator</code> property.
   * @see com.tridium.ddfIp.tcp.BDdfTcpGatewayNetwork#communicator
   */
  public BValue getCommunicator() { return get(communicator); }
  
  /**
   * Set the <code>communicator</code> property.
   * @see com.tridium.ddfIp.tcp.BDdfTcpGatewayNetwork#communicator
   */
  public void setCommunicator(BValue v) { set(communicator,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BDdfTcpGatewayNetwork.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
 
}
